/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.timeline.widgets;

import cz.cuni.amis.nb.pogamut.unreal.timeline.records.LogEvent;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLEntity;
import cz.cuni.amis.nb.pogamut.unreal.timeline.widgets.LogCategoryWidget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.widget.LabelWidget;

public class LogEventWidget
extends LabelWidget {
    private LogCategoryWidget logAxisWidget;
    private LogEvent logEvent;
    public static final int height = 14;
    private TLEntity entity;
    private LabelWidget.VerticalAlignment valign = LabelWidget.VerticalAlignment.CENTER;
    protected final int zoomFactor = 100;
    protected final int LEFT_MARGIN = 80;

    public LogEventWidget(LogCategoryWidget logAxisWidget, LogEvent logEvent) {
        super(logAxisWidget.getScene());
        this.setLabel(logEvent.getMessage());
        this.setFont(this.getScene().getDefaultFont().deriveFont(14));
        this.logAxisWidget = logAxisWidget;
        this.logEvent = logEvent;
        this.entity = logAxisWidget.getEntity();
        this.setVerticalAlignment(this.valign);
        this.setToolTipText(logEvent.getMessage());
        this.setBorder(BorderFactory.createRoundedBorder((int)0, (int)0, (Color)this.entity.getColor(), (Color)Color.BLACK));
        this.updateLocation();
    }

    public void updateLocation() {
        long endTS = Math.min(this.entity.getEndTime(), this.logEvent.getEndTS());
        int startOffset = this.getStartOffset() + this.getOffsetFromStart(this.logEvent.getStartTS());
        int ypos = this.logEvent.getSlot() * 14 + this.logAxisWidget.getStripHeight();
        int length = this.getTimeframeLength(this.logEvent.getStartTS(), endTS);
        Point location = new Point(startOffset, ypos);
        Rectangle rect = new Rectangle(new Dimension(length, 14));
        this.setPreferredLocation(location);
        this.setPreferredBounds(rect);
    }

    protected final int getStartOffset() {
        long dbStartMilis = this.entity.getDatabase().getStartTime();
        int delta = (int)(this.entity.getStartTime() - dbStartMilis) / 100;
        return delta + 80;
    }

    protected final int getOffsetFromStart(long ms) {
        long delta = ms - this.entity.getStartTime();
        int offset = (int)(delta / 100L);
        return offset;
    }

    protected final int getTimeframeLength(long startTS, long endTS) {
        return this.getTimeframeLength(endTS - startTS);
    }

    protected final int getTimeframeLength(long delta) {
        return (int)(delta / 100L);
    }
}

