/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.timeline.view;

import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLDatabase;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class TLSlider
extends JSlider
implements ChangeListener {
    private TLDatabase db;
    private final TLDatabase.Adapter timeListener = new TLDatabase.Adapter(){

        @Override
        public void currentTimeChanged(long previousCurrentTime, long currentTime) {
            long timeframe = currentTime - TLSlider.this.db.getStartTime();
            TLSlider.this.removeChangeListener(TLSlider.this);
            TLSlider.this.setValue((int)timeframe);
            TLSlider.this.addChangeListener(TLSlider.this);
        }

        @Override
        public void endTimeChanged(long previousEndTime, long endTime) {
            long timeframe = endTime - TLSlider.this.db.getStartTime();
            TLSlider.this.setMaximum((int)timeframe);
        }
    };

    public TLSlider(TLDatabase db) {
        super(0, (int)db.getElapsedTime(), (int)db.getDeltaTime());
        this.db = db;
        this.addChangeListener(this);
        this.db.addDBListener(this.timeListener);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        TLSlider source = (TLSlider)e.getSource();
        int value = source.getValue();
        if ((long)value + this.db.getStartTime() != this.db.getCurrentTime()) {
            this.db.setCurrentTime((long)value + this.db.getStartTime());
        }
    }
}

