/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.map;

import cz.cuni.amis.nb.pogamut.unreal.timeline.map.EnvironmentRenderer;
import cz.cuni.amis.nb.pogamut.unreal.timeline.map.GLRendererCollection;
import cz.cuni.amis.nb.pogamut.unreal.timeline.map.IRenderableUTAgent;
import cz.cuni.amis.nb.pogamut.unreal.timeline.map.ISubGLRenderer;
import cz.cuni.amis.nb.pogamut.unreal.timeline.map.MapController;
import cz.cuni.amis.nb.pogamut.unreal.timeline.map.MapRenderer;
import cz.cuni.amis.nb.pogamut.unreal.timeline.map.MapViewpoint;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.worldview.map.IUnrealMap;
import java.awt.Point;
import java.beans.Beans;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLJPanel;

public abstract class MapGLPanel
extends GLJPanel
implements MapViewpoint.ViewpointListener {
    protected Logger logger;
    protected MapViewpoint mapViewpoint;
    protected MapController mapController;
    protected MapRenderer mapRenderer;
    protected GLRendererCollection<IRenderableUTAgent> agentRenderes;
    protected EnvironmentRenderer environmentRenderer;
    protected int lastGLName = 1;
    private IUnrealMap map;

    protected MapGLPanel(GLCapabilities caps, IUnrealMap map, Logger log) {
        super(caps);
        if (Beans.isDesignTime()) {
            Beans.setDesignTime(false);
        }
        this.map = map;
        this.logger = log;
        Location mapFocus = new Location(map.getBox().getCenterX(), map.getBox().getCenterY(), map.getBox().getCenterZ());
        this.mapViewpoint = new MapViewpoint();
        this.mapController = new MapController(this, this.mapViewpoint, mapFocus);
        this.mapController.registerListeners();
        this.mapRenderer = new MapRenderer(map, this.lastGLName++);
        this.agentRenderes = new GLRendererCollection();
        this.environmentRenderer = new EnvironmentRenderer(this.mapViewpoint, this.agentRenderes, this.mapRenderer);
        this.addGLEventListener(this.environmentRenderer);
        this.mapViewpoint.addViewpointListener(this);
        this.mapViewpoint.setFromViewedBox(map.getBox());
    }

    protected MapGLPanel(IUnrealMap map, Logger log) {
        this(MapGLPanel.getCapabilities(), map, log);
    }

    private static GLCapabilities getCapabilities() {
        GLCapabilities caps = new GLCapabilities();
        caps.setHardwareAccelerated(true);
        caps.setDoubleBuffered(true);
        return caps;
    }

    @Override
    public synchronized void onChangedViewpoint(MapViewpoint viewpoint) {
        this.display();
    }

    public synchronized Set<IRenderableUTAgent> getAgentsAt(Point p) {
        this.environmentRenderer.setSelectPoint(p);
        this.display();
        int[] list = this.environmentRenderer.getSelectedObjects();
        HashSet<IRenderableUTAgent> selectedAgents = new HashSet<IRenderableUTAgent>();
        for (ISubGLRenderer<IRenderableUTAgent> agentRenderer : this.agentRenderes.getSubRenderes()) {
            IRenderableUTAgent renderableAgent = agentRenderer.getObject();
            for (int glName : list) {
                if (glName != renderableAgent.getGLName()) continue;
                selectedAgents.add(renderableAgent);
            }
        }
        return selectedAgents;
    }

    public synchronized void destroy() {
        this.removeGLEventListener(this.environmentRenderer);
        this.mapViewpoint.removeViewpointListener(this);
        this.mapRenderer = null;
        this.environmentRenderer = null;
        this.agentRenderes = null;
        this.mapController = null;
        this.mapViewpoint = null;
    }

    protected IUnrealMap getMap() {
        return this.map;
    }
}

