/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.timeline;

import cz.cuni.amis.nb.pogamut.unreal.timeline.TLEntityNode;
import cz.cuni.amis.nb.pogamut.unreal.timeline.dataobject.TLDataObject;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLDatabase;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLEntity;
import cz.cuni.amis.nb.util.NodeFactory;
import cz.cuni.amis.nb.util.collections.ObservableCollectionNode;
import cz.cuni.amis.utils.collections.ObservableCollection;
import cz.cuni.amis.utils.collections.ObservableSet;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openide.cookies.OpenCookie;
import org.openide.nodes.Node;

class StoredTimelineNode
extends ObservableCollectionNode<TLEntity> {
    private TLDataObject dataObj;
    private TLDatabase.Adapter newEntitiesListener = new TLDatabase.Adapter(){

        @Override
        public void onEntityEntered(TLDatabase db, TLEntity entity) {
            StoredTimelineNode.this.getChildrenCollection().add((Object)entity);
        }
    };

    public StoredTimelineNode(TLDataObject obj) {
        super((ObservableCollection)new ObservableSet(new HashSet()), (NodeFactory)new NodeFactory<TLEntity>(){

            public Node[] create(TLEntity entity) {
                TLEntityNode node = new TLEntityNode(entity.getDatabase(), entity);
                return new Node[]{node};
            }
        });
        this.dataObj = obj;
        this.setName(this.dataObj.getName() + " (" + this.dataObj.getMapName() + ")");
        for (TLEntity entity : obj.getDatabase().getEntities()) {
            this.getChildrenCollection().add((Object)entity);
        }
        this.dataObj.getDatabase().addDBListener(this.newEntitiesListener);
    }

    public Action getPreferredAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenCookie oc = (OpenCookie)StoredTimelineNode.this.dataObj.getLookup().lookup(OpenCookie.class);
                if (oc != null) {
                    oc.open();
                }
            }
        };
    }
}

