/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.timeline.records;

import cz.cuni.amis.nb.pogamut.unreal.timeline.records.LogEvent;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.LogMessage;
import cz.cuni.amis.pogamut.base.utils.logging.marks.LogEventMark;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LogEvents
implements Serializable {
    private LinkedList<LogMessage> logMessages = new LinkedList();
    private LinkedList<LogEvent> allEvents = new LinkedList();
    private ArrayList<LogEvent> unfinishedEvents = new ArrayList();
    private ArrayList<LogSlot> slots = new ArrayList();

    private int getFreeSlot(long time) {
        int slotIndex = 0;
        for (LogSlot slot : this.slots) {
            if (slot.endTime < time) {
                return slotIndex;
            }
            ++slotIndex;
        }
        this.slots.add(new LogSlot(null, Integer.MIN_VALUE));
        return this.slots.size() - 1;
    }

    private LogEventMark hasMark(LogRecord record) {
        for (Object o : record.getParameters()) {
            if (!(o instanceof LogEventMark)) continue;
            return (LogEventMark)o;
        }
        return null;
    }

    LogMessage updateLogMessages(LogRecord record) {
        LogEventMark mark = this.hasMark(record);
        if (mark == null) {
            return null;
        }
        if (mark.getType() == LogEventMark.Type.SINGLE_EVENT) {
            LogMessage newMessage = new LogMessage(record, mark);
            this.logMessages.add(newMessage);
            return newMessage;
        }
        return null;
    }

    LogEvent updateLogEvents(LogRecord record) {
        LogEventMark mark = this.hasMark(record);
        if (mark == null) {
            return null;
        }
        if (mark.getType() == LogEventMark.Type.FIXED_DURATION) {
            int slot = this.getFreeSlot(mark.getTime());
            LogEvent newLogEvent = new LogEvent(record, mark, slot);
            this.slots.get(slot).update(newLogEvent);
            this.allEvents.add(newLogEvent);
            return newLogEvent;
        }
        if (mark.getType() == LogEventMark.Type.START_EVENT) {
            int slot = this.getFreeSlot(mark.getTime());
            LogEvent newLogEvent = new LogEvent(record, mark, slot);
            this.slots.get(slot).update(newLogEvent);
            this.unfinishedEvents.add(newLogEvent);
            this.allEvents.add(newLogEvent);
            return newLogEvent;
        }
        if (mark.getType() == LogEventMark.Type.END_EVENT) {
            LogEvent unfinished = this.getUnfinishedEventWithMark(mark);
            if (unfinished == null) {
                if (Logger.getLogger("global").isLoggable(Level.SEVERE)) {
                    Logger.getLogger("global").severe("Got end of log event, but no such event started. Possibly duplicated end. Record message " + record.getMessage());
                }
                return null;
            }
            this.finishEvent(unfinished, record);
            return null;
        }
        return null;
    }

    private LogEvent getUnfinishedEventWithMark(LogEventMark mark) {
        for (LogEvent event : this.unfinishedEvents) {
            if (event.getMark().getId() != mark.getId()) continue;
            return event;
        }
        return null;
    }

    private void finishEvent(LogEvent unfinished, LogRecord closingRecord) {
        unfinished.revievedClosingRecord(closingRecord);
        this.slots.get(unfinished.getSlot()).endTime = unfinished.getEndTS();
        this.unfinishedEvents.remove(unfinished);
    }

    public List<LogMessage> getMessages() {
        return Collections.unmodifiableList(this.logMessages);
    }

    public List<LogEvent> getEvents() {
        return Collections.unmodifiableList(this.allEvents);
    }

    private static class LogSlot
    implements Serializable {
        private LogEvent event;
        private long endTime;

        public LogSlot(LogEvent event, long endTime) {
            this.event = event;
            this.endTime = endTime;
        }

        public void update(LogEvent event) {
            this.event = event;
            this.endTime = event.getEndTS();
        }
    }
}

