/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.timeline.records;

import cz.cuni.amis.introspection.Folder;
import cz.cuni.amis.introspection.IntrospectionException;
import cz.cuni.amis.introspection.Property;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLProperty;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class TLFolder
implements Serializable {
    protected String name;
    public LinkedList<TLProperty> properties = new LinkedList();
    public LinkedList<TLFolder> subfolders = new LinkedList();

    public TLFolder(Folder folder) throws IntrospectionException {
        this.name = folder.getName();
        for (Property property : folder.getProperties()) {
            this.addProperty(new TLProperty(property.getName(), property.getType()));
        }
        for (Property property : folder.getFolders()) {
            this.addFolder(new TLFolder((Folder)property));
        }
    }

    public TLFolder(String name) {
        this.name = name;
    }

    public void addFolder(TLFolder newSubfolder) {
        this.subfolders.add(newSubfolder);
    }

    public void addProperty(TLProperty newProperty) {
        this.properties.add(newProperty);
    }

    public TLFolder findFolder(String name) {
        for (TLFolder subfolder : this.getSubfolders()) {
            String folderName = subfolder.getName();
            if (!(folderName == null ? name == null : folderName.equals(name))) continue;
            return subfolder;
        }
        return null;
    }

    public TLProperty findProperty(String name) {
        for (TLProperty property : this.getProperties()) {
            String propName = property.getName();
            if (!(propName == null ? name == null : propName.equals(name))) continue;
            return property;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public List<TLProperty> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    public List<TLFolder> getSubfolders() {
        return Collections.unmodifiableList(this.subfolders);
    }
}

