/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.server;

import cz.cuni.amis.nb.api.pogamut.base.server.ServerDefinition;
import cz.cuni.amis.nb.api.pogamut.base.server.ServerTypesManager;
import cz.cuni.amis.nb.api.pogamut.unreal.server.UnrealServerDefinition;
import cz.cuni.amis.nb.pogamut.base.NamedAction;
import cz.cuni.amis.nb.pogamut.base.server.ServerNode;
import cz.cuni.amis.nb.pogamut.unreal.map.PureMapTopComponent;
import cz.cuni.amis.nb.pogamut.unreal.server.AgentsNode;
import cz.cuni.amis.nb.pogamut.unreal.server.PlayersNode;
import cz.cuni.amis.nb.pogamut.unreal.server.TimelinesNode;
import cz.cuni.amis.nb.util.flag.FlagChildren;
import cz.cuni.amis.pogamut.unreal.communication.messages.gbinfomessages.IMapList;
import cz.cuni.amis.pogamut.unreal.server.IUnrealServer;
import cz.cuni.amis.pogamut.unreal.server.exception.MapChangeException;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.FlagListener;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.PropertiesAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public abstract class UnrealServerNode<T extends UnrealServerDefinition>
extends ServerNode<T> {
    Sheet.Set unrealProps = null;
    protected static final String UT_SHEET = "UTPropSet";
    private Action openMapAction;

    public UnrealServerNode(T serverDefinition, String serversManagerID) {
        super(serverDefinition, ServerTypesManager.getServersManager((String)serversManagerID), (Children)new FlagChildren(serverDefinition.getServerFlag()){

            protected Node[] createNodes(Object arg0) {
                if (arg0 != FlagChildren.EMPTY) {
                    IUnrealServer server = (IUnrealServer)arg0;
                    return new Node[]{new AgentsNode(server), new PlayersNode(server), new TimelinesNode(server)};
                }
                return new Node[0];
            }
        });
    }

    protected String createName() {
        IUnrealServer server = (IUnrealServer)((UnrealServerDefinition)this.serverDef).getServerFlag().getFlag();
        String name = (String)((UnrealServerDefinition)this.serverDef).getServerNameFlag().getFlag();
        if (server != null && server.getMapName() != null) {
            return name + " [" + server.getMapName() + "]";
        }
        return name;
    }

    protected Image getServerIcon() {
        return ImageUtilities.loadImage((String)"cz/cuni/amis/nb/pogamut/ut2004/server/UT2004Servers.gif");
    }

    protected Sheet.Set createPropSet() {
        Sheet.Set propset = Sheet.createPropertiesSet();
        propset.setName("UnrealProps");
        propset.setDisplayName("Unreal Properties");
        propset.put((Node.Property)new MapProperty());
        return propset;
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        this.unrealProps = this.createPropSet();
        sheet.put(this.unrealProps);
        return sheet;
    }

    public Action[] getActions(boolean context) {
        Action[] oldActs = super.getActions(context);
        Action[] acts = Arrays.copyOf(oldActs, oldActs.length + 7);
        acts[oldActs.length + 1] = this.getPreferredAction();
        acts[oldActs.length + 2] = new NamedAction("ACT_Spectate", UnrealServerNode.class){

            protected void action(ActionEvent e) throws PogamutException {
                try {
                    ((UnrealServerDefinition)UnrealServerNode.this.serverDef).spectate();
                }
                catch (PogamutException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        };
        acts[oldActs.length + 4] = new ServerNode.ServerUpAction<IUnrealServer>("ACT_AddNativeBot", UnrealServerNode.class, this.serverDef){

            protected void action(ActionEvent e) throws PogamutException {
                NotifyDescriptor.InputLine botTypeDialog = new NotifyDescriptor.InputLine("Bot type (optional): ", "Native bot type");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)botTypeDialog);
                if (botTypeDialog.isValid()) {
                    String botType = botTypeDialog.getInputText().trim();
                    ((IUnrealServer)this.getServer()).connectNativeBot(null, botType);
                }
            }
        };
        acts[oldActs.length + 6] = SystemAction.get(PropertiesAction.class);
        return acts;
    }

    public Action getPreferredAction() {
        if (this.openMapAction == null) {
            this.openMapAction = new OpenPureMap();
        }
        return this.openMapAction;
    }

    protected class OpenPureMap
    extends NamedAction {
        private String uid;

        public OpenPureMap() {
            super("ACT_OpenMap", UnrealServerNode.class);
        }

        public synchronized void action(ActionEvent e) {
            if (((UnrealServerDefinition)UnrealServerNode.this.serverDef).getServerFlag().getFlag() != null) {
                TopComponent map = WindowManager.getDefault().findTopComponent(this.uid);
                if (map == null) {
                    map = new PureMapTopComponent((ServerDefinition<IUnrealServer>)UnrealServerNode.this.serverDef);
                    this.uid = WindowManager.getDefault().findTopComponentID(map);
                }
                map.open();
                map.requestActive();
            }
        }
    }

    protected class MapProperty
    extends Node.Property {
        int[] keys;
        String[] mapNames;
        static final String noMap = "N/A";
        Map<String, Integer> mapToKey;
        boolean serverUp;

        public MapProperty() {
            super(Integer.class);
            this.serverUp = false;
            this.setDisplayName("Map");
            this.setName("serverMap");
            ((UnrealServerDefinition)UnrealServerNode.this.getServerDefinition()).getServerFlag().addListener((FlagListener)new FlagListener<IUnrealServer>(){

                public void flagChanged(IUnrealServer changedValue) {
                    MapProperty.this.initValues(changedValue);
                    try {
                        UnrealServerNode.this.firePropertyChange(MapProperty.this.getName(), null, MapProperty.this.getValue());
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
            this.initValues((IUnrealServer)((UnrealServerDefinition)UnrealServerNode.this.getServerDefinition()).getServerFlag().getFlag());
        }

        protected void initValues(IUnrealServer server) {
            if (server != null) {
                this.serverUp = true;
                Collection maps = server.getAvailableMaps();
                this.mapNames = new String[maps.size()];
                this.mapToKey = new HashMap<String, Integer>();
                this.keys = new int[maps.size()];
                int i = 0;
                for (IMapList map : maps) {
                    String name;
                    this.mapNames[i] = name = map.getName();
                    this.keys[i] = i;
                    this.mapToKey.put(name.toUpperCase(), i);
                    ++i;
                }
            } else {
                this.serverUp = false;
                this.keys = new int[]{0};
                this.mapNames = new String[]{noMap};
            }
            this.setValue("intValues", this.keys);
            this.setValue("stringKeys", this.mapNames);
        }

        public boolean canRead() {
            return true;
        }

        public boolean canWrite() {
            return this.serverUp;
        }

        public void setValue(Object val) {
            try {
                ((IUnrealServer)((UnrealServerDefinition)UnrealServerNode.this.getServerDefinition()).getServerFlag().getFlag()).setGameMap(this.mapNames[(Integer)val]);
            }
            catch (MapChangeException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public Object getValue() {
            if (this.serverUp) {
                return this.mapToKey.get(((IUnrealServer)((UnrealServerDefinition)UnrealServerNode.this.getServerDefinition()).getServerFlag().getFlag()).getMapName().toUpperCase());
            }
            return 0;
        }
    }
}

