/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.unreal.timeline;

import cz.cuni.amis.nb.pogamut.unreal.services.IPogamutEnvironments;
import cz.cuni.amis.nb.pogamut.unreal.timeline.TLFolderNode;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLDatabase;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLEntity;
import cz.cuni.amis.nb.pogamut.unreal.timeline.records.TLFolder;
import cz.cuni.amis.nb.util.NodeFactory;
import cz.cuni.amis.nb.util.collections.ObservableCollectionNode;
import cz.cuni.amis.pogamut.unreal.communication.worldview.map.IUnrealMap;
import cz.cuni.amis.utils.collections.ObservableCollection;
import cz.cuni.amis.utils.collections.ObservableList;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

class TLEntityNode
extends ObservableCollectionNode<TLFolder>
implements LookupListener {
    private TLEntity entity;
    private TLDatabase db;
    private Lookup.Template<TLEntity> lookupTemplate;
    private Lookup.Result<TLEntity> lookupResult = null;
    private final TLDatabase.Adapter currentTimeListener = new TLDatabase.Adapter(){

        @Override
        public void currentTimeChanged(long previousCurrentTime, long currentTime) {
            TLEntityNode.this.setDisplayName(TLEntityNode.this.entity.getDisplayName() + "(" + (Object)((Object)TLEntityNode.this.getEntityStateInTime(currentTime)) + ")");
            Node[] nodes = TLEntityNode.this.getChildren().getNodes();
            if (nodes != null) {
                for (Node n : nodes) {
                    ((TLFolderNode)n).updateToTime(currentTime);
                }
            }
        }
    };
    private boolean htmlName = false;

    public TLEntityNode(TLDatabase db, TLEntity ent) {
        super((ObservableCollection)new ObservableList(new LinkedList()), (NodeFactory)new NodeFactory<TLFolder>(){

            public Node[] create(TLFolder obj) {
                return new Node[]{new TLFolderNode(obj)};
            }
        });
        this.db = db;
        this.entity = ent;
        this.setDisplayName(this.entity.getDisplayName() + "(" + (Object)((Object)this.getEntityStateInTime(db.getCurrentTime())) + ")");
        this.getChildrenCollection().add((Object)this.entity.getFolder());
        this.db.addDBListener(this.currentTimeListener);
        IPogamutEnvironments environments = (IPogamutEnvironments)Lookup.getDefault().lookup(IPogamutEnvironments.class);
        if (environments == null) {
            return;
        }
        IUnrealMap map = db.getMap();
        this.lookupTemplate = new Lookup.Template(TLEntity.class);
        this.lookupResult = environments.getEnvironmentSelection(map).lookup(this.lookupTemplate);
        this.lookupResult.addLookupListener((LookupListener)this);
    }

    private TLEntity.State getEntityStateInTime(long time) {
        if (time < this.entity.getStartTime()) {
            return TLEntity.State.INSTANTIATED;
        }
        if (time <= this.entity.getEndTime()) {
            return TLEntity.State.RECORDING;
        }
        return TLEntity.State.FINISHED;
    }

    public String getHtmlDisplayName() {
        if (this.htmlName) {
            return "<b>" + this.getDisplayName() + "</b>";
        }
        return null;
    }

    public void resultChanged(LookupEvent lookupEvent) {
        boolean newHtmlName = false;
        Lookup.Result selected = (Lookup.Result)lookupEvent.getSource();
        for (TLEntity selectedEntity : selected.allInstances()) {
            if (selectedEntity != this.entity) continue;
            newHtmlName = true;
        }
        if (newHtmlName != this.htmlName) {
            this.htmlName = newHtmlName;
            this.fireDisplayNameChange(null, null);
        }
    }

    public void destroy() throws IOException {
        this.lookupResult.removeLookupListener((LookupListener)this);
        super.destroy();
    }

    public Action getPreferredAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IPogamutEnvironments environments = (IPogamutEnvironments)Lookup.getDefault().lookup(IPogamutEnvironments.class);
                if (environments == null) {
                    return;
                }
                environments.getEnvironmentSelection(TLEntityNode.this.db.getMap()).changeSelected(TLEntityNode.this.entity);
                Action original = TLEntityNode.super.getPreferredAction();
                if (original != null) {
                    original.actionPerformed(e);
                }
            }
        };
    }
}

