/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.api.pogamut.base.server;

import cz.cuni.amis.nb.pogamut.base.server.ServerNode;
import cz.cuni.amis.pogamut.base.server.IWorldServer;
import cz.cuni.amis.utils.flag.Flag;
import java.io.Serializable;
import java.net.URI;

public abstract class ServerDefinition<SERVER extends IWorldServer>
implements Serializable {
    String name = "Initialize server name";
    transient Flag<String> nameFlag = null;
    URI uri = null;
    transient Flag<URI> uriFlag = null;
    private transient Flag<SERVER> serverFlag = null;

    public ServerDefinition() {
        this.init();
    }

    public void init() {
        this.nameFlag = new Flag((Object)this.name);
        this.uriFlag = new Flag((Object)this.uri);
        this.serverFlag = new Flag(null);
        if (this.getUri() != null) {
            this.startServer();
        }
    }

    public void setServerName(String name) {
        this.name = name;
        this.nameFlag.setFlag((Object)name);
    }

    public String getServerName() {
        return this.name;
    }

    public Flag<String> getServerNameFlag() {
        return this.nameFlag.getImmutable();
    }

    public void setUri(URI uri) {
        this.uri = uri;
        this.uriFlag.setFlag((Object)uri);
        this.startServer();
    }

    public URI getUri() {
        return this.uri;
    }

    public Flag<URI> getUriFlag() {
        return this.uriFlag.getImmutable();
    }

    protected void setNewServer(SERVER server) {
        this.serverFlag.setFlag(server);
    }

    public abstract ServerNode getViewer();

    public Flag<SERVER> getServerFlag() {
        return this.serverFlag.getImmutable();
    }

    public abstract void startServer();

    public abstract void stopServer();
}

