/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.base.server;

import cz.cuni.amis.nb.api.pogamut.base.server.ServerDefinition;
import cz.cuni.amis.nb.api.pogamut.base.server.ServersManager;
import cz.cuni.amis.nb.pogamut.base.NamedAction;
import cz.cuni.amis.nb.pogamut.base.server.ServerDefAgents;
import cz.cuni.amis.nb.util.NodeFactory;
import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.server.IWorldServer;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.FlagListener;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.ImageUtilities;

public abstract class ServerNode<T extends ServerDefinition>
extends AbstractNode {
    ServersManager<T> serversManager = null;
    protected T serverDef = null;
    protected IWorldServer actualServer = null;
    protected FlagListener<IAgentState> serverStateListener = new FlagListener<IAgentState>(){

        public void flagChanged(IAgentState changedValue) {
            ServerNode.this.serverStateChangeHandler(changedValue);
        }
    };
    FlagListener serverListener = new FlagListener(){

        public void flagChanged(Object changedValue) {
            ServerNode.this.serverChangedHandler((IWorldServer)changedValue);
        }
    };

    public void serverChangedHandler(IWorldServer newServer) {
        this.registerServerStateListener(newServer);
        this.setDisplayName(this.createName());
        this.fireIconChange();
    }

    public void registerServerStateListener(IWorldServer newServer) {
        if (this.actualServer != null) {
            this.actualServer.getState().removeListener(this.serverStateListener);
        }
        this.actualServer = newServer;
        if (this.actualServer != null) {
            newServer.getState().addListener(this.serverStateListener);
        }
    }

    public void serverStateChangeHandler(IAgentState serverState) {
        this.setDisplayName(this.createName());
    }

    public ServerNode(T serverDef, ServersManager<T> serversManager, final NodeFactory<IAgent> nodeFactory) {
        super((Children)new ServerDefAgents((ServerDefinition)serverDef){

            protected Node[] createNodes(IAgent arg0) {
                return nodeFactory.create(arg0);
            }
        });
        this.init(serverDef);
        this.serversManager = serversManager;
    }

    public ServerNode(T serverDef, ServersManager<T> serversManager, Children children) {
        super(children);
        this.init(serverDef);
        this.serversManager = serversManager;
        ((ServerDefinition)serverDef).getServerFlag().addListener(this.serverListener);
    }

    protected void init(T serverDef) {
        this.serverDef = serverDef;
        this.setDisplayName(this.createName());
        if (((ServerDefinition)serverDef).getServerFlag().getFlag() != null) {
            this.registerServerStateListener((IWorldServer)((ServerDefinition)serverDef).getServerFlag().getFlag());
        }
        ((ServerDefinition)serverDef).getServerNameFlag().addListener((FlagListener)new FlagListener<String>(){

            public void flagChanged(String changedValue) {
                ServerNode.this.setDisplayName(ServerNode.this.createName());
            }
        });
    }

    protected T getServerDefinition() {
        return this.serverDef;
    }

    public Action[] getActions(boolean context) {
        return new Action[]{new NamedAction("ACT_RemoveServer"){

            @Override
            public void action(ActionEvent e) throws PogamutException {
                ServerNode.this.serversManager.removeServer(ServerNode.this.serverDef);
            }
        }};
    }

    protected String createName() {
        return ((ServerDefinition)this.serverDef).getServerNameFlag().getFlag() + " [" + ((ServerDefinition)this.serverDef).getUriFlag().getFlag().toString() + "]";
    }

    void updateNodeName() {
        String name = this.createName();
        if (this.isDefaultServer()) {
            name = "<b>" + name + "</b>";
        }
        this.setDisplayName(name);
    }

    boolean isDefaultServer() {
        return this.serversManager.getDefaultServer().getFlag() == this.serverDef;
    }

    protected abstract Class<? extends PropertyEditor> getURIPropEditorClass();

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set props = sheet.get("properties");
        if (props == null) {
            props = Sheet.createPropertiesSet();
            sheet.put(props);
        }
        try {
            ReflProp prop = new ReflProp(this.serverDef, URI.class, "uri", "URI");
            prop.setPropertyEditorClass(this.getURIPropEditorClass());
            props.put(new Node.Property[]{new ReflProp(this.serverDef, String.class, "serverName", "Server name"), prop});
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        return sheet;
    }

    protected abstract Image getServerIcon();

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public Image getIcon(int type) {
        Object server = ((ServerDefinition)this.getServerDefinition()).getServerFlag().getFlag();
        Image badge = null;
        badge = server == null ? this.getBadgeIcon("Error") : this.getBadgeIcon("Running");
        return ImageUtilities.mergeImages((Image)this.getServerIcon(), (Image)badge, (int)4, (int)4);
    }

    private Image getBadgeIcon(String badge) {
        return ImageUtilities.loadImage((String)("cz/cuni/amis/nb/pogamut/base/icons/" + badge + "BadgeIcon.png"));
    }

    public static abstract class ServerUpAction<T extends IWorldServer>
    extends NamedAction {
        ServerDefinition<T> def = null;

        public ServerUpAction(String key, Class cls, ServerDefinition<T> def) {
            super(key, cls);
            this.def = def;
        }

        @Override
        public boolean isEnabled() {
            return this.getServer() != null;
        }

        protected T getServer() {
            return (T)((IWorldServer)this.def.getServerFlag().getFlag());
        }
    }

    public static class FlagProp
    extends PropertySupport.ReadWrite<String> {
        Flag<String> flag;

        public FlagProp(Flag<String> flag, String propName, String shortDescr) {
            super(flag.toString(), String.class, propName, shortDescr);
            this.flag = flag;
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return (String)this.flag.getFlag();
        }

        public void setValue(String arg0) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.flag.setFlag((Object)arg0);
        }
    }

    public static class ReflProp
    extends PropertySupport.Reflection {
        String name = null;

        public ReflProp(Object o, Class c, String prop, String dispName) throws NoSuchMethodException {
            super(o, c, prop);
            this.setName(prop);
            this.name = dispName;
        }

        public String getDisplayName() {
            return this.name;
        }
    }
}

