/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.api.pogamut.base.server;

import cz.cuni.amis.nb.api.pogamut.base.server.ServerDefinition;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateFailed;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateStopped;
import cz.cuni.amis.pogamut.base.server.IWorldServer;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.FlagListener;
import org.openide.util.Exceptions;

public abstract class ReconnectingServerDefinition<T extends IWorldServer>
extends ServerDefinition<T> {
    transient FlagListener<IAgentState> flagListener;

    public ReconnectingServerDefinition() {
        this.flagListener = this.flagListener = new FlagListener<IAgentState>(){

            public void flagChanged(IAgentState changedValue) {
                if (changedValue.isState(new Class[]{IAgentStateStopped.class, IAgentStateFailed.class})) {
                    ReconnectingServerDefinition.this.serverStopped((IWorldServer)ReconnectingServerDefinition.this.getServerFlag().getFlag());
                    ReconnectingServerDefinition.this.startServer();
                }
            }
        };
        this.getServerFlag().addListener(new FlagListener<T>(){

            public void flagChanged(T changedValue) {
                if (changedValue != null) {
                    changedValue.getState().addListener(ReconnectingServerDefinition.this.flagListener);
                }
            }
        });
    }

    protected void serverStopped(T server) {
        server.getState().removeListener(this.flagListener);
        this.setNewServer(null);
    }

    @Override
    public void stopServer() {
        IWorldServer server = (IWorldServer)this.getServerFlag().getFlag();
        if (server != null) {
            server.getState().removeListener(this.flagListener);
            server.stop();
        }
    }

    @Override
    public void startServer() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                boolean notConnected = true;
                while (notConnected) {
                    try {
                        ReconnectingServerDefinition.this.tryToStartServer();
                        notConnected = false;
                    }
                    catch (Exception ex) {
                        if (ReconnectingServerDefinition.this.getServerFlag().getFlag() != null) {
                            ReconnectingServerDefinition.this.setNewServer(null);
                        }
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException ex1) {
                            Exceptions.printStackTrace((Throwable)ex1);
                        }
                    }
                }
            }
        }, "UTServer-reconnecting-thread").start();
    }

    protected abstract void tryToStartServer() throws PogamutException;
}

