/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package cz.cuni.amis.pogamut.pogamutlevelmetadata;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

/**
 *
 * @author Martin Cerny
 */
public abstract class AbstractXStreamMetaDataProviderFactory<ObjectId> implements ILevelMetaDataProviderFactory<ObjectId, String> {
    
    /**
     * Implementations provide a way to get an input stream for particular level, containing the metatada.
     * @param levelName
     * @return input stream or null if no metadata is found.
     * @throws IOException 
     */
    protected abstract InputStream getInputStreamForLevelName(String levelName) throws IOException;

    XStream xstream = new XStream();

    public AbstractXStreamMetaDataProviderFactory() {
    }

    @Override
    public ILevelMetaDataProvider<ObjectId> getMetadataProvider(String levelIdentification) {
        Object metadata;
        InputStream inputStream = null;
        try {
            inputStream = getInputStreamForLevelName(levelIdentification);
            if(inputStream == null){
                return null;
            }                    
            metadata = xstream.fromXML(inputStream);
            inputStream.close();
        } catch (Exception ex) {
            throw new MetadataLoadingException("Could not load metadata for level " + levelIdentification ,ex);
        }
        if(!(metadata instanceof List)){
            throw new MetadataLoadingException("Loaded object is not a list");
        }
        return new ListLevelMetaDataProvider<ObjectId>((List)metadata);
    }

    public void aliasType(String name, Class type) {
        xstream.aliasType(name, type);
    }

    public void aliasField(String alias, Class type, String fieldName) {
        xstream.aliasField(alias, type, fieldName);
    }

    public void aliasAttribute(Class configurableClass, String attributeName, String alias) {
        xstream.aliasAttribute(configurableClass, attributeName, alias);
    }

    public void aliasAttribute(String alias, String attributeName) {
        xstream.aliasAttribute(alias, attributeName);
    }

    public void alias(String name, Class type, Class defaultImplementation) {
        xstream.alias(name, type, defaultImplementation);
    }

    public void alias(String name, Class type) {
        xstream.alias(name, type);
    }



}
