package cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;

/**
 * Holds anotated places in the map EmohawkVille.
 * TODO - needs check.
 * @author knight
 */
public enum Place {
    BARBARA_HOME(new Location(12809,-12262,-3424), 200),
    NATALY_HOME(new Location(14600,3315,-3424), 200),
    NATALY_WAIT_PLACE(new Location(13500,-950,-3424), 200),
    SCEN_LONE_MEETING_POINT(new Location(15500,-9493,-3420), 200),
    EMOHAWK_ROAM_LOCATION(new Location(5500,-7200,-3424), 200),
    THOMAS_HOME(new Location(14600,3315,-3424), 200),
    RESTAURANT(new Location(-4658,704,-3419), 200),
    CINEMA(new Location(-327,-7364,-3420), 200),
    PARK(new Location(2864,-2923,-3416), 200),
    SPHERE(new Location(5518,-1923,-3416), 200);

    /** exact place middle location */
    Location placeLocation;
    /** place raidus in unreal units 1 ut unit is approx. 1 cm*/
    double placeRadius;

    public Location getPlaceLocation() {
        return placeLocation;
    }

    public double getPlaceRadius() {
        return placeRadius;
    }

    public boolean placeReached(Location location) {
        if (location == null) return false;

        if (location.getDistance(placeLocation) <= placeRadius)
            return true;

        return false;
    }

    public boolean placeReached(Location location, double epsilon) {
        if (location == null) return false;

        if (location.getDistance(placeLocation) <= (placeRadius + epsilon))
            return true;

        return false;
    }

    /** default constructor */
    Place(Location location, double radius) {
        placeLocation = location;
        placeRadius = radius;
    }
}
