package cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric;

import java.util.HashMap;

/**
 * Enum holding all available Pogamut items in UnrealEngine2RuntimeDemo and UDK.
 * @author knight
 */
public enum ItemType {

    BALL("GBEmohawk.ItemBall","GameBotsUDK.ItemBall"),
    BOOK("GBEmohawk.ItemBook","GameBotsUDK.ItemBook"),
    BOOKOPENED("GBEmohawk.ItemBookOpened", "GameBotsUDK.ItemBookOpened"),
    BROCCOLI("GBEmohawk.ItemBroccoli", "GameBotsUDK.ItemBroccoli"),
    CONDOM("GBEmohawk.ItemCondom", "GameBotsUDK.ItemCondom"),
    COOKER("GBEmohawk.ItemCooker", "GameBotsUDK.ItemCooker"),
    CUP("GBEmohawk.ItemCup", "GameBotsUDK.ItemCup"),
    DICE("GBEmohawk.ItemDice", "GameBotsUDK.ItemDice"),
    FLOWER("GBEmohawk.ItemFlower", "GameBotsUDK.ItemFlower"),
    GUN("GBEmohawk.ItemGun", "GameBotsUDK.ItemGun"),
    HEART("GBEmohawk.ItemHeart", "GameBotsUDK.ItemHeart"),
    PLATE("GBEmohawk.ItemPlate", "GameBotsUDK.ItemPlate"),
    POT("GBEmohawk.ItemPot", "GameBotsUDK.ItemPot"),
    SHOES("GBEmohawk.ItemShoes", "GameBotsUDK.ItemShoes"),
    SHOESUNTIDY("GBEmohawk.ItemShoesUntidy", "GameBotsUDK.ItemShoesUntidy"),
    SOAP("GBEmohawk.ItemSoap", "GameBotsUDK.ItemSoap"),
    SOAPBOX("GBEmohawk.ItemSoapbox", "GameBotsUDK.ItemSoapbox"),
    SPOON("GBEmohawk.ItemSpoon", "GameBotsUDK.ItemSpoon"),
    TEDDY("GBEmohawk.ItemTeddy", "GameBotsUDK.ItemTeddy"),
    TOOTHBRUSH("GBEmohawk.ItemToothbrush", "GameBotsUDK.ItemToothbrush"),
    NONE("None", "None");

    /** Name of the class representing the object in UE2 */
    String ue2Name;
    /** Name of the class representing the object in UDK */
    String udkName;
    
    public static HashMap<String, ItemType> nameMap = new HashMap();

    public static ItemType getItemType(String name) {
        if (nameMap.containsKey(name))
            return nameMap.get(name);
        else
            return ItemType.NONE;
    }

    public String getUE2Name() {
        return ue2Name;
    }

    public String getUDKName() {
        return udkName;
    }
    
    ItemType(String ue2Name, String udkName) {
        this.ue2Name = ue2Name;
        this.udkName = udkName;
    }

    static {
        for (ItemType type : ItemType.values()) {
            nameMap.put(type.getUE2Name(), type);
        }
    }
}
