/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric;

import cz.cuni.amis.pogamut.base.agent.IEmbodiedAgent;
import cz.cuni.amis.pogamut.base.agent.module.SensomotoricModule;
import cz.cuni.amis.pogamut.base.communication.command.ICommandListener;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.AnimType;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.AnimationCharacterMapping;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.CharacterType;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.PlayAnimation;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import java.util.HashSet;
import java.util.logging.Logger;

public class Animations
extends SensomotoricModule<UT2004Bot> {
    AnimationCharacterMapping animCharMapping;
    CharacterType currentCharacterType = null;
    Self self;
    ICommandListener<Initialize> initCommandListener = new ICommandListener<Initialize>(){

        public void notify(Initialize event) {
            if (event.getClassName() != null && !event.getClassName().isEmpty()) {
                for (CharacterType charType : CharacterType.values()) {
                    if (!charType.getUE2Class().contains(event.getClassName()) && !charType.getUDKClass().contains(event.getClassName())) continue;
                    Animations.this.currentCharacterType = charType;
                }
            }
        }
    };
    IWorldObjectListener<Self> storeSelfListener = new IWorldObjectListener<Self>(){

        public void notify(IWorldObjectEvent<Self> event) {
            if (Animations.this.self == null) {
                Animations.this.self = (Self)event.getObject();
                Animations.this.worldView.removeObjectListener(Self.class, (IWorldObjectEventListener)this);
                Animations.this.storeSelfListener = null;
            }
        }
    };

    public AnimType getPlayerAnimation(Player player) {
        return AnimationCharacterMapping.getAnimTypeFromString(player.getAnim());
    }

    public AnimType getCurrentPlayedAnimation() {
        if (this.self == null) {
            return AnimType.NONE;
        }
        return AnimationCharacterMapping.getAnimTypeFromString(this.self.getAnim());
    }

    public HashSet<AnimType> getAvailableAnimations(CharacterType charType) {
        return AnimationCharacterMapping.getAvailableAnimations(charType);
    }

    public HashSet<AnimType> getAvailableAnimations() {
        if (this.currentCharacterType != null) {
            return AnimationCharacterMapping.getAvailableAnimations(this.currentCharacterType);
        }
        return new HashSet<AnimType>();
    }

    public void playAnimation(AnimType animation, boolean bLoop) {
        if (!AnimationCharacterMapping.hasAnim(animation, this.currentCharacterType)) {
            String outString = "Character " + (Object)((Object)this.currentCharacterType) + " does not own " + animation.getUnrealID() + " animation.";
            this.getLog().warning(outString);
        }
        this.act.act((CommandMessage)new PlayAnimation(animation.getUnrealID(), Boolean.valueOf(bLoop)));
    }

    public void playAnimation(AnimType animation) {
        if (!AnimationCharacterMapping.hasAnim(animation, this.currentCharacterType)) {
            String outString = "Character " + (Object)((Object)this.currentCharacterType) + " does not own " + animation.getUnrealID() + " animation.";
            this.getLog().warning(outString);
        }
        this.act.act((CommandMessage)new PlayAnimation(animation.getUnrealID(), Boolean.FALSE));
    }

    public void stopAnimation() {
    }

    public CharacterType getCurrentCharacter() {
        return this.currentCharacterType;
    }

    public Animations(UT2004Bot agent, Logger log) {
        super((IEmbodiedAgent)agent, log);
        this.animCharMapping = new AnimationCharacterMapping();
        this.act.addCommandListener(Initialize.class, this.initCommandListener);
        this.worldView.addObjectListener(Self.class, this.storeSelfListener);
    }

    public Animations(UT2004Bot agent) {
        super((IEmbodiedAgent)agent);
        this.animCharMapping = new AnimationCharacterMapping();
        this.act.addCommandListener(Initialize.class, this.initCommandListener);
        this.worldView.addObjectListener(Self.class, this.storeSelfListener);
    }
}

