package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.vegetable;


/** Carrot slices
 */
public class CarrotSliceReplica extends AbstractVegetableSliceReplica implements ICarrotSlice {
	
	public static final float BOILEDNESS_PER_MAGNITUDE_PER_SECOND = 0.025f;
	public static final float CHARREDNESS_PER_MAGNITUDE_PER_SECOND = 0.1f;
	public static final float BROTH_STRENGTH_POTENTIAL = 0.04f;
		
	@Override
	public String getDisplayName() {
		return "Carrot slice";
	}
	
	@Override
	protected void initializeParameters()
	{
		ingredientComponent.initializeBoilingBehavior(
			CarrotReplica.COOKING_BASE_TEMPERATURE,
			CarrotReplica.COOKING_STANDARD_TEMPERATURE,
			BOILEDNESS_PER_MAGNITUDE_PER_SECOND
		);
		ingredientComponent.initializeCharringBehavior(
			CarrotReplica.COOKING_BASE_TEMPERATURE,
			CarrotReplica.COOKING_STANDARD_TEMPERATURE,
			CHARREDNESS_PER_MAGNITUDE_PER_SECOND,
			CarrotReplica.CHARREDNESS_RESISTANCE,
			CarrotReplica.CHARREDNESS_RESISTANCE_STIRRING_BONUS,
			CarrotReplica.MAX_BUFFERED_CHARREDNESS
		);
		brothStrengthPotential = BROTH_STRENGTH_POTENTIAL;
		volumePerSlice = CarrotReplica.VOLUME_PER_WHOLE/CarrotReplica.SLICES_PER_WHOLE;
	}
}