package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.vegetable;

import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;

/** Broccoli
 */
public class BroccoliReplica extends AbstractVegetableReplica implements IBroccoli {
	
	public static final float BOILEDNESS_PER_MAGNITUDE_PER_SECOND = 0.0175f;
	public static final float CHARREDNESS_PER_MAGNITUDE_PER_SECOND = 0.125f;
	public static final float CHARREDNESS_RESISTANCE = 0.025f;
	public static final float CHARREDNESS_RESISTANCE_STIRRING_BONUS = 0.025f;
	public static final float MAX_BUFFERED_CHARREDNESS = 0.25f;
	public static final float BROTH_STRENGTH_POTENTIAL = 0.04f;
	public static final float VOLUME_PER_WHOLE = 0.200f;
	public static final float SLICES_PER_SECOND = 4.0f;
	public static final int SLICES_PER_WHOLE = 40;
	
	@Override
	public boolean isPieceItem( IItem item ) {
		return item instanceof IBroccoliSlice;
	}
	
	@Override
	public String getDisplayName() {
		return "Broccoli";
	}
	
	@Override
	protected void initializeParameters() {
		ingredientComponent.initializeBoilingBehavior(
			COOKING_BASE_TEMPERATURE,
			COOKING_STANDARD_TEMPERATURE,
			BOILEDNESS_PER_MAGNITUDE_PER_SECOND
		);
		ingredientComponent.initializeCharringBehavior(
			COOKING_BASE_TEMPERATURE,
			COOKING_STANDARD_TEMPERATURE,
			CHARREDNESS_PER_MAGNITUDE_PER_SECOND,
			CHARREDNESS_RESISTANCE,
			CHARREDNESS_RESISTANCE_STIRRING_BONUS,
			MAX_BUFFERED_CHARREDNESS
		);
		brothStrengthPotential = BROTH_STRENGTH_POTENTIAL;
		volumePerWhole = VOLUME_PER_WHOLE;
		slicesPerSecond = SLICES_PER_SECOND;
		slicesPerWhole = SLICES_PER_WHOLE;
	}
}