package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.action;

import java.util.Collection;

import cz.cuni.amis.pogamut.emohawk.agent.module.essence.EssenceDistanceTools;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.AbstractActionReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IActionResultHandler;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.SerializationTools;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.StreamBuffer;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.IPawn;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.PawnReplica;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.DishwarePlateReplica;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.IDishwarePlate;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.IFork;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.IKnife;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.ISpoon;

/** Action that startes eating food from a plate
 */
public class EatActionReplica extends AbstractActionReplica {

	public static final int ERROR_PERFORMER_NOT_PAWN = 10;
	public static final int ERROR_PLATE_INVALID = 11;
	public static final int ERROR_REQUIRES_CUTLERY_SET = 12;
	public static final int ERROR_PAWN_BUSY = 13;
	public static final int ERROR_OUT_OF_RANGE = 14;
	public static final int ERROR_PLATE_EMPTY = 15;
	
	public static final String RANGE_ATTR = "range";
	
	@Override
	public String getActionName() {
		return "Eat";
	}
	
	/** Get range
	 */
	public float getRange() {
		return attributes.floats().get( RANGE_ATTR );
	}
	
	/** Tell if the pawn can reach the cooking pot
	 */
	public boolean canReach( IPawn pawn, IDishwarePlate plate, float rangeMultiplier )
	{
		return (
			EssenceDistanceTools.computeDistanceOfEssences( pawn, plate )
			<=
			getRange()*rangeMultiplier
		);
	}
		
	/** Tell if list contains cutlery set
	 * 
	 * Cutlery set consists of a knife, a fork and a spoon.
	 */
	public boolean containsCutlerySet( Collection<? extends IItem> list )
	{
		boolean foundKnife, foundFork, foundSpoon;
		foundKnife = false;
		foundFork = false;
		foundSpoon = false;
	
		for ( IItem item : list )
		{
			if ( item instanceof IKnife )
			{
				foundKnife = true;
			}
			if ( item instanceof IFork )
			{
				foundFork = true;
			}
			if ( item instanceof ISpoon )
			{
				foundSpoon = true;
			}
		}
	
		return foundKnife && foundFork && foundSpoon;
	}
	
	/** Request
	 * 
	 * Client-side only.
	 * 
	 * @param performer action performer
	 * @param plate plate to eat from
	 * @param resultHandler result handler
	 */
	public void request( PawnReplica performer, DishwarePlateReplica plate, IActionResultHandler resultHandler )
	{
		StreamBuffer arguments = new StreamBuffer();
		SerializationTools.serializeObjectReferenceOnClient( arguments, plate );
		performer.requestAction(
			this,
			resultHandler,
			arguments
		);
	}
}