package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.vegetable;


/** YellowPepper slices
 */
public class YellowPepperSliceReplica extends AbstractVegetableSliceReplica implements IYellowPepperSlice {
	
	public static final float BOILEDNESS_PER_MAGNITUDE_PER_SECOND = 0.025f; 
	public static final float CHARREDNESS_PER_MAGNITUDE_PER_SECOND = 0.05f; 
	public static final float CHARREDNESS_RESISTANCE = 0.025f; 
	public static final float CHARREDNESS_RESISTANCE_STIRRING_BONUS = 0.075f; 
	public static final float MAX_BUFFERED_CHARREDNESS = 1.0f; 
	public static final float BROTH_STRENGTH_POTENTIAL = 0.04f; 
	public static final float VOLUME_PER_SLICE = 0.005f; 

	@Override
	public String getDisplayName() {
		return "Yellow pepper slice";
	}
	
	@Override
	protected void initializeParameters() {
		ingredientComponent.initializeBoilingBehavior(
			YellowPepperReplica.COOKING_BASE_TEMPERATURE,
			YellowPepperReplica.COOKING_STANDARD_TEMPERATURE,
			BOILEDNESS_PER_MAGNITUDE_PER_SECOND
		);
		ingredientComponent.initializeCharringBehavior(
			YellowPepperReplica.COOKING_BASE_TEMPERATURE,
			YellowPepperReplica.COOKING_STANDARD_TEMPERATURE,
			CHARREDNESS_PER_MAGNITUDE_PER_SECOND,
			CHARREDNESS_RESISTANCE,
			CHARREDNESS_RESISTANCE_STIRRING_BONUS,
			MAX_BUFFERED_CHARREDNESS
		);
		brothStrengthPotential = BROTH_STRENGTH_POTENTIAL;
		volumePerSlice = VOLUME_PER_SLICE;
	}
}