package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.meat;

import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;

/** Pork
 */
public class PorkReplica extends AbstractMeatReplica implements IPork {

	public static final float BOILEDNESS_PER_MAGNITUDE_PER_SECOND = 0.0025f; 
	public static final float FRIEDNESS_PER_MAGNITUDE_PER_SECOND = 0.0125f; 
	public static final float CHARREDNESS_PER_MAGNITUDE_PER_SECOND = 0.250f; 
	public static final float CHARREDNESS_RESISTANCE = 0.0f; 
	public static final float CHARREDNESS_RESISTANCE_STIRRING_BONUS = 0.0f; 
	public static final float MAX_BUFFERED_CHARREDNESS = 25.0f; 
	public static final float BROTH_STRENGTH_POTENTIAL = 0.1f; 
	public static final float VOLUME_PER_WHOLE = 0.250f; 
	public static final float SLICES_PER_SECOND = 1f; 
	public static final int SLICES_PER_WHOLE = 10; 
	
	@Override
	public String getDisplayName() {
		return "Pork";
	}
	
	@Override
	public boolean isPieceItem( IItem item )
	{
		return item instanceof PorkBitReplica;
	}
	
	@Override
	protected void initializeParameters() 
	{
		ingredientComponent.initializeBoilingBehavior(
			BOILING_BASE_TEMPERATURE,
			BOILING_STANDARD_TEMPERATURE,
			BOILEDNESS_PER_MAGNITUDE_PER_SECOND
		);
		ingredientComponent.initializeFryingBehavior(
			FRYING_BASE_TEMPERATURE,
			FRYING_STANDARD_TEMPERATURE,
			FRIEDNESS_PER_MAGNITUDE_PER_SECOND
		);
		ingredientComponent.initializeCharringBehavior(
			CHARRING_BASE_TEMPERATURE,
			CHARRING_STANDARD_TEMPERATURE,
			CHARREDNESS_PER_MAGNITUDE_PER_SECOND,
			CHARREDNESS_RESISTANCE,
			CHARREDNESS_RESISTANCE_STIRRING_BONUS,
			MAX_BUFFERED_CHARREDNESS
		);
		brothStrengthPotential = BROTH_STRENGTH_POTENTIAL;
		volumePerWhole = VOLUME_PER_WHOLE;
		slicesPerSecond = SLICES_PER_SECOND;
		slicesPerWhole = SLICES_PER_WHOLE;
	}
}