package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.action;

import java.util.Collection;

import cz.cuni.amis.pogamut.emohawk.agent.module.essence.EssenceDistanceTools;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.AbstractActionReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IActionResultHandler;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.SerializationTools;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.StreamBuffer;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.IPawn;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.PawnReplica;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.StovePlateReplica;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.IStirringSpoon;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.cookware.CookingPotReplica;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.cookware.ICookingPot;

/** Action that stirs a cooking pot
 */
public class StirActionReplica extends AbstractActionReplica {
	
	public static final int ERROR_PERFORMER_NOT_PAWN = 10; 
	public static final int ERROR_COOKING_POT_INVALID = 11; 
	public static final int ERROR_REQUIRES_STIRRING_SPOON = 12; 
	public static final int ERROR_PAWN_BUSY = 13; 
	public static final int ERROR_OUT_OF_RANGE = 14; 
	public static final int ERROR_COOKING_POT_BUSY = 15;
	
	public static final float DEFAULT_RANGE = 200.0f;
	
	protected static final String RANGE_ATTR = "range"; 
	
	@Override
	public String getActionName() {
		return "Stir";
	}
	
	/** Get range
	 */
	public float getRange() {
		return attributes.floats().get( RANGE_ATTR );
	}
			
	/** Tell if the pawn can reach the cooking pot
	 */
	public boolean canReach( IPawn pawn, ICookingPot cookingPot, float rangeMultiplier )
	{
		if ( cookingPot.getOwnerPossessor() instanceof StovePlateReplica ) {
			return 	(
				EssenceDistanceTools.computeDistanceOfEssences( pawn, cookingPot.getOwnerPossessor() )
				<=
				getRange()*rangeMultiplier
			);
		}
	
		return (
			EssenceDistanceTools.computeDistanceOfEssences( pawn, cookingPot )
			<=
			getRange()*rangeMultiplier
		);
	}
	
	/** Find a knife in a list
	 */
	public IStirringSpoon findStirringSpoon( Collection<? extends IItem> list )
	{
		for ( IItem item : list ) {
			if ( item instanceof IStirringSpoon ) {
				return (IStirringSpoon) item;
			}
		}
		return null;
	}
	
	/** Request
	 * 
	 * @param performer action performer
	 * @param cookingPot cooking pot to stir
	 * @param resultHandler result handler
	 */
	public void request( PawnReplica performer, CookingPotReplica cookingPot, IActionResultHandler resultHandler )
	{
		StreamBuffer arguments = new StreamBuffer();
		SerializationTools.serializeObjectReferenceOnClient( arguments, cookingPot );
		performer.requestAction(
			this,
			resultHandler,
			arguments
		);
	}
}