package cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.item.utensil;

import java.util.Collection;

import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IDeferredConstructorChainer;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.item.container.AbstractContainerItemMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.ObservationMemory;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.item.ingredient.IIngredientMemorization;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.FoodTools;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.DishwarePlateReplica;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.IDishwarePlate;

/** Dishware plate memorization
 * 
 * @author Paletz
 */
public class DishwarePlateMemorization
	extends AbstractContainerItemMemorization<DishwarePlateReplica> 
	implements IDishwarePlate {
	
	public DishwarePlateMemorization(
		DishwarePlateReplica object,
		ObservationMemory observationMemory,
		IDeferredConstructorChainer deferredConstructorChainer
	) {
		super( object, observationMemory, deferredConstructorChainer );
	}

	@Override
	public String getDisplayName() {
		return DishwarePlateReplica.DISPLAY_NAME;
	}

	@Override
	public Collection<? extends IIngredientMemorization<?>> readIngredients() {
		return FoodTools.readIngredients( readInventory() );
	}
	
	@Override
	public boolean canStore( IItem item ) {
		return FoodTools.canStoreFood( readIngredients(), item, DishwarePlateReplica.FOOD_CAPACITY );
	}
	
	@Override
	public boolean canRelease( IItem item ) {
		return false;
	}
}