/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.WaterReplication;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.IIngredient;
import java.util.Collection;

public class FoodTools {
    public static <IngredientType extends IIngredient, ItemType extends IItem> Collection<? extends IngredientType> readIngredients(Collection<? extends ItemType> inventory) {
        return Collections2.transform(inventory, (Function)new Function<ItemType, IngredientType>(){

            public IngredientType apply(ItemType arg) {
                assert (arg instanceof IIngredient);
                IIngredient retval = (IIngredient)arg;
                return retval;
            }
        });
    }

    public static boolean canStoreFood(Collection<? extends IIngredient> ingredients, IItem item, float foodCapacity) {
        if (!(item instanceof IIngredient)) {
            return false;
        }
        IIngredient ingredient = (IIngredient)item;
        if (item instanceof WaterReplication) {
            WaterReplication water = (WaterReplication)item;
            return foodCapacity - FoodTools.computeFoodVolume(ingredients) > water.getAmount();
        }
        return foodCapacity - FoodTools.computeFoodVolume(ingredients) > ingredient.getVolume();
    }

    public static float computeFoodVolume(Collection<? extends IIngredient> ingredients) {
        float retval = 0.0f;
        for (IIngredient iIngredient : ingredients) {
            retval += iIngredient.getVolume();
        }
        return retval;
    }
}

