package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.vegetable;


/** Carrot slices
 */
public class CarrotSliceReplication extends AbstractVegetableSliceReplication implements ICarrotSlice {
	
	public static final float BOILEDNESS_PER_MAGNITUDE_PER_SECOND = 0.025f;
	public static final float CHARREDNESS_PER_MAGNITUDE_PER_SECOND = 0.1f;
	public static final float BROTH_STRENGTH_POTENTIAL = 0.04f;
		
	@Override
	public String getDisplayName() {
		return "Carrot slice";
	}
	
	@Override
	protected void initializeParameters()
	{
		ingredientComponent.initializeBoilingBehavior(
			CarrotReplication.COOKING_BASE_TEMPERATURE,
			CarrotReplication.COOKING_STANDARD_TEMPERATURE,
			BOILEDNESS_PER_MAGNITUDE_PER_SECOND
		);
		ingredientComponent.initializeCharringBehavior(
			CarrotReplication.COOKING_BASE_TEMPERATURE,
			CarrotReplication.COOKING_STANDARD_TEMPERATURE,
			CHARREDNESS_PER_MAGNITUDE_PER_SECOND,
			CarrotReplication.CHARREDNESS_RESISTANCE,
			CarrotReplication.CHARREDNESS_RESISTANCE_STIRRING_BONUS,
			CarrotReplication.MAX_BUFFERED_CHARREDNESS
		);
		brothStrengthPotential = BROTH_STRENGTH_POTENTIAL;
		volumePerSlice = CarrotReplication.VOLUME_PER_WHOLE/CarrotReplication.SLICES_PER_WHOLE;
	}
}