package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.meat;


/** Pork slices
 * 
 * Cooking behavior is same as pork's.
 */
public class PorkBitReplication extends AbstractMeatBitReplication implements IPorkBit {
	
	@Override
	public String getDisplayName() {
		return "Pork slice";
	}
	
	@Override
	protected void initializeParameters() {
		ingredientComponent.initializeBoilingBehavior(
			PorkReplication.BOILING_BASE_TEMPERATURE,
			PorkReplication.BOILING_STANDARD_TEMPERATURE,
			PorkReplication.BOILEDNESS_PER_MAGNITUDE_PER_SECOND
		);
		ingredientComponent.initializeFryingBehavior(
			PorkReplication.FRYING_BASE_TEMPERATURE,
			PorkReplication.FRYING_STANDARD_TEMPERATURE,
			PorkReplication.FRIEDNESS_PER_MAGNITUDE_PER_SECOND
		);
		ingredientComponent.initializeCharringBehavior(
			PorkReplication.CHARRING_BASE_TEMPERATURE,
			PorkReplication.CHARRING_STANDARD_TEMPERATURE,
			PorkReplication.CHARREDNESS_PER_MAGNITUDE_PER_SECOND,
			PorkReplication.CHARREDNESS_RESISTANCE,
			PorkReplication.CHARREDNESS_RESISTANCE_STIRRING_BONUS,
			PorkReplication.MAX_BUFFERED_CHARREDNESS
		);
		brothStrengthPotential = PorkReplication.BROTH_STRENGTH_POTENTIAL;
		volumePerSlice = PorkReplication.VOLUME_PER_WHOLE/PorkReplication.SLICES_PER_WHOLE;
	}
}