package cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.item.ingredient.meat;

import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IDeferredConstructorChainer;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.ObservationMemory;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.item.ingredient.AbstractSolidIngredientMemorization;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.item.ingredient.IFriableIngredientMemorization;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.meat.AbstractMeatReplication;

public abstract class AbstractMeatMemorization
	<MemorizedClass extends AbstractMeatReplication> 
	extends AbstractSolidIngredientMemorization<MemorizedClass>
	implements IFriableIngredientMemorization<MemorizedClass> {
	
	protected float topFriedness, bottomFriedness;
	protected boolean isUpsideDown;
	
	public AbstractMeatMemorization( 
		MemorizedClass object,
		ObservationMemory observationMemory,
		IDeferredConstructorChainer deferredConstructorChainer
	) {
		super( object, observationMemory, deferredConstructorChainer );
		topFriedness = object.getTopFriedness();
		bottomFriedness = object.getBottomFriedness();
		isUpsideDown = object.getIsUpsideDown();
	}	
	
	@Override
	public float getTopFriedness() {
		return topFriedness;
	}
	
	@Override
	public float getBottomFriedness() {
		return bottomFriedness;
	}

	@Override
	public boolean getIsUpsideDown() {
		return isUpsideDown;
	}
}
