package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil;

import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.container.AbstractContainerItemReplication;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.PawnReplication;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.IChoppableItem;

/** Chopping board
 *  
 * Can hold one choppable cooking ingredient. 
 */
public class ChoppingBoardReplication extends AbstractContainerItemReplication implements IChoppingBoard {
		
	public static final String CHOPPER_ATTR = "chopper";
	public static final String DISPLAY_NAME = "Chopping board"; 
	
	@Override
	public String getDisplayName() {
		return DISPLAY_NAME;
	}
	
	@Override
	public boolean canStore( IItem item ) {
		return canStore( this, item );
	}
	
	@Override
	public PawnReplication getChopper() {
		return (PawnReplication) attributes.refs().get( CHOPPER_ATTR );
	}
	
	/** See {@link #canStore(IItem)}
	 */
	public static boolean canStore( IChoppingBoard choppingBoard, IItem item ) {
		return (
			item instanceof IChoppableItem
			&&
			(
				choppingBoard.readInventory().size() == 0
				||
				(
					choppingBoard.readInventory().size() == 1
					&&
					((IChoppableItem) item).isPieceItem( choppingBoard.readInventory().iterator().next() )
				)
			)
		);
	}
}