package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.vegetable;

import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;

/** Cucumber
 *
 * @author Paletz
 */
public class CucumberReplication extends AbstractVegetableReplication implements ICucumber {

	public static final float BOILEDNESS_PER_MAGNITUDE_PER_SECOND = 0.0075f;
	public static final float CHARREDNESS_PER_MAGNITUDE_PER_SECOND = 0.125f;
	public static final float CHARREDNESS_RESISTANCE = 0.025f;
	public static final float CHARREDNESS_RESISTANCE_STIRRING_BONUS = 0.50f;
	public static final float MAX_BUFFERED_CHARREDNESS = 0.5f;
	public static final float BROTH_STRENGTH_POTENTIAL = 0.01f;
	public static final float VOLUME_PER_WHOLE = 0.400f;
	public static final float SLICES_PER_SECOND = 4.0f;
	public static final int SLICES_PER_WHOLE = 40;
	
	@Override
	public String getDisplayName() {
		return "Cucumber";
	}
	
	@Override
	public boolean isPieceItem( IItem item ) {
		return item instanceof ICucumberSlice;
	}
	
	@Override
	protected void initializeParameters() {
		ingredientComponent.initializeBoilingBehavior(
			COOKING_BASE_TEMPERATURE,
			COOKING_STANDARD_TEMPERATURE,
			BOILEDNESS_PER_MAGNITUDE_PER_SECOND
		);
		ingredientComponent.initializeCharringBehavior(
			COOKING_BASE_TEMPERATURE,
			COOKING_STANDARD_TEMPERATURE,
			CHARREDNESS_PER_MAGNITUDE_PER_SECOND,
			CHARREDNESS_RESISTANCE,
			CHARREDNESS_RESISTANCE_STIRRING_BONUS,
			MAX_BUFFERED_CHARREDNESS
		);
		brothStrengthPotential = BROTH_STRENGTH_POTENTIAL;
		volumePerWhole = VOLUME_PER_WHOLE;
		slicesPerSecond = SLICES_PER_SECOND;
		slicesPerWhole = SLICES_PER_WHOLE;
	}
}