package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.vegetable;


/** Broccoli slices
 */
public class BroccoliSliceReplication extends AbstractVegetableSliceReplication implements IBroccoliSlice {
	
	public static final float BROTH_STRENGTH_POTENTIAL = 0.05f; // in strength per volume*magnitude*time
	
	@Override
	public String getDisplayName() {
		return "Broccoli slice";
	}
	
	@Override
	protected void initializeParameters()
	{
		ingredientComponent.initializeBoilingBehavior(
			BroccoliReplication.COOKING_BASE_TEMPERATURE,
			BroccoliReplication.COOKING_STANDARD_TEMPERATURE,
			BroccoliReplication.BOILEDNESS_PER_MAGNITUDE_PER_SECOND
		);
		ingredientComponent.initializeCharringBehavior(
			BroccoliReplication.COOKING_BASE_TEMPERATURE,
			BroccoliReplication.COOKING_STANDARD_TEMPERATURE,
			BroccoliReplication.CHARREDNESS_PER_MAGNITUDE_PER_SECOND,
			BroccoliReplication.CHARREDNESS_RESISTANCE,
			BroccoliReplication.CHARREDNESS_RESISTANCE_STIRRING_BONUS,
			BroccoliReplication.MAX_BUFFERED_CHARREDNESS
		);
		brothStrengthPotential = BROTH_STRENGTH_POTENTIAL;
		volumePerSlice = BroccoliReplication.VOLUME_PER_WHOLE/BroccoliReplication.SLICES_PER_WHOLE;
	}
}