package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient;

/** A cooking ingredient that can be fried
 */
public interface IFriableIngredient extends IIngredient {

	/** Get bottom friedness
	 *  
	 * @return how much is the ingredient fried on bottom on a scale zero to one (completely fried)
	 */
	public float getBottomFriedness();
	
	/** Get top friedness
	 *  
	 * @return how much is the ingredient fried on top on a scale zero to one (completely fried)
	 */
	public float getTopFriedness();
	
	/** Tell if the ingredients is placed upside down
	 *  
	 * @return true if the ingredients is placed upside down
	 */
	public boolean getIsUpsideDown();
}
