package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.action;

import cz.cuni.amis.pogamut.emohawk.agent.module.essence.EssenceDistanceTools;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.AbstractActionReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IActionReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IActionResultHandler;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.SerializationTools;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.StreamBuffer;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.IPawn;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.IStove;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.PawnReplication;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.StoveReplication;

/** Action that sets power of a stove plate
 */
public class SetStovePowerActionReplication extends AbstractActionReplication implements IActionReplication {

	public static final int ERROR_PERFORMER_NOT_PAWN = 10;
	public static final int ERROR_TARGET_INVALID = 11;
	public static final int ERROR_PLATE_INDEX_INVALID = 12;
	public static final int ERROR_POWER_INVALID = 13;
	public static final int ERROR_OUT_OF_RANGE = 14;
	
	protected static final String RANGE_ATTR = "range";
	
	@Override
	public String getActionName() {
		return "Set power";
	}

	/** Get range
	 */
	public float getRange() {
		return attributes.floats().get( RANGE_ATTR );
	}
	
	/** Tell if chopper can reach the chopping board 
	 */
	public boolean canReach( IPawn pawn, IStove stove, float rangeMultiplier ) {
		return ( 
			EssenceDistanceTools.computeDistanceOfEssences( pawn, stove ) 
			<=
			getRange()*rangeMultiplier
		);
	}
	
	/** Request
	 * 
	 * Client-side only.
	 * 
	 * @param performer action performer
	 * @param stove to set power on
	 * @param resultHandler result handler
	 */
	public void request( PawnReplication performer, StoveReplication stove, int plateIndex, int power, IActionResultHandler resultHandler )
	{
		StreamBuffer arguments =  new StreamBuffer();
		SerializationTools.serializeObjectReferenceOnClient( arguments, stove );
		arguments.writeInt( plateIndex );
		arguments.writeInt( power );
		performer.requestAction(
			this,
			resultHandler,
			arguments
		);
	}
}
