package cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.action;

import java.util.Collection;

import cz.cuni.amis.pogamut.emohawk.agent.module.essence.EssenceDistanceTools;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.AbstractActionReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IActionResultHandler;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.SerializationTools;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.StreamBuffer;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.ICountableItemReplication;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.ISubstanceItemReplication;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.IPawn;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.PawnReplication;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.IIngredientReplication;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.DishwarePlateReplication;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.IDishwarePlate;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.IScoop;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.ITurner;

/** Serve food from cookware onto a plate
 */
public class ServeFoodActionReplication extends AbstractActionReplication {
	
	public static final int ERROR_PERFORMER_NOT_PAWN = 10; 
	public static final int ERROR_INGREDIENT_INVALID = 11; 
	public static final int ERROR_PLATE_INVALID = 12; 
	public static final int ERROR_INGREDIENT_NOT_IN_OWNED_COOKWARE = 13; 
	public static final int ERROR_OUT_OF_RANGE = 14; 
	public static final int ERROR_SCOOP_REQUIRED = 15; 
	public static final int ERROR_TURNER_REQUIRED = 16; 
	public static final int ERROR_QUANTITY_INVALID = 17; 
	public static final int ERROR_PLATE_FULL = 18;
	
	public static final float DEFAULT_RANGE = 200.0f; 
	
	protected static final String RANGE_ATTR = "range"; 
	
	@Override
	public String getActionName() {
		return "Serve food";
	}
	
	/** Get range
	 */
	public float getRange() {
		return attributes.floats().get( RANGE_ATTR );
	}
	
	/** Tell if the collector can drop an item at the location
	 */
	public boolean canReach( IPawn pawn, IDishwarePlate plate, double rangeMultiplier ) {
		return ( 
			EssenceDistanceTools.computeDistanceOfEssences( pawn, plate ) 
			<=
			getRange()*rangeMultiplier
		);
	}
	
	/** Find scoop in a list
	 */
	public IScoop findScoop( Collection<? extends IItem> list ) {
		for ( IItem item : list ) {
			if ( item instanceof IScoop ) {
				return (IScoop) item;
			}
		}
		return null;
	}
	
	/** Find turner in inventory
	 */
	public ITurner findTurner( Collection<? extends IItem> list ) {
		for ( IItem item : list ) {
			if ( item instanceof ITurner ) {
				return (ITurner) item;
			}
		}
		return null;
	}
	
	/** Request to drop at current collector location
	 *  
	 * @param performer action performer
	 * @param ingredient ingredient to serve
	 * @param plate plate to serve on
	 * @param resultHandler result handler
	 */
	public void request( PawnReplication performer, IIngredientReplication ingredient, DishwarePlateReplication plate, IActionResultHandler resultHandler )
	{
		StreamBuffer arguments = new StreamBuffer();
		SerializationTools.serializeObjectReferenceOnClient( arguments, ingredient );
		SerializationTools.serializeObjectReferenceOnClient( arguments, plate );
		performer.requestAction( 
			this, 
			resultHandler, 
			arguments 
		);
	}
	
	/** Request to drop at current collector location
	 *  
	 * @param performer action performer
	 * @param ingredient ingredient to serve, must be countable
	 * @param plate plate to serve on
	 * @param count number of pieces to serve
	 * @param resultHandler result handler
	 */
	public void requestWithCount( PawnReplication performer, IIngredientReplication ingredient, DishwarePlateReplication plate, int count, IActionResultHandler resultHandler ) {
		StreamBuffer arguments = new StreamBuffer();
		assert( ingredient instanceof ICountableItemReplication );
		SerializationTools.serializeObjectReferenceOnClient( arguments, ingredient );
		SerializationTools.serializeObjectReferenceOnClient( arguments, plate );
		arguments.writeInt( count );
		performer.requestAction( 
			this, 
			resultHandler, 
			arguments 
		);
	}
	
	/** Request to drop at current collector location
	 *  
	 * @param performer action performer
	 * @param ingredient ingredient to serve, must be a substance
	 * @param plate plate to serve on
	 * @param amount how much to serve
	 * @param resultHandler result handler
	 */
	public void requestWithAmount( PawnReplication performer, IIngredientReplication ingredient, DishwarePlateReplication plate, float amount, IActionResultHandler resultHandler ) {
		StreamBuffer arguments = new StreamBuffer(); 
		assert( ingredient instanceof ISubstanceItemReplication );
		SerializationTools.serializeObjectReferenceOnClient( arguments, ingredient );
		SerializationTools.serializeObjectReferenceOnClient( arguments, plate );
		arguments.writeFloat( amount );
		performer.requestAction( 
			this, 
			resultHandler, 
			arguments 
		);
	}
}