package cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.item.ingredient;

import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IDeferredConstructorChainer;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.item.AbstractSubstanceItemMemorization;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.ObservationMemory;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.ISpaghetti;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.SpaghettiReplication;

/** Spaghetti memorization
 * 
 * @author Paletz
 */
public class SpaghettiMemorization 
	extends AbstractSubstanceItemMemorization<SpaghettiReplication>
	implements ISpaghetti, ICharrableIngredientMemorization<SpaghettiReplication>, IBoilableIngredientMemorization<SpaghettiReplication> {

	protected float boiledness, charredness;
	
	public SpaghettiMemorization( 
		SpaghettiReplication object,
		ObservationMemory observationMemory,
		IDeferredConstructorChainer deferredConstructorChainer
	) {
		super( object, observationMemory, deferredConstructorChainer );
		boiledness = object.getBoiledness();
		charredness = object.getCharredness();
	}
	
	@Override
	public float getBoiledness() {
		return boiledness;
	}
	
	@Override
	public float getCharredness() {
		return charredness;
	}

	@Override
	public float getVolume() {
		return getAmount()*SpaghettiReplication.VOLUME_PER_GRAM;
	}
}
