package cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.item.ingredient;

import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IDeferredConstructorChainer;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.item.AbstractItemMemorization;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.ObservationMemory;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.item.IChoppableItemMemorization;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.AbstractSolidIngredientReplication;

public abstract class AbstractSolidIngredientMemorization
	<MemorizedClass extends AbstractSolidIngredientReplication>
	extends AbstractItemMemorization<MemorizedClass>
	implements IChoppableItemMemorization<MemorizedClass>, IBrothableIngredientMemorization<MemorizedClass>, ICharrableIngredientMemorization<MemorizedClass>, IBoilableIngredientMemorization<MemorizedClass> {
	
	protected float fraction, boiledness, charredness, brothStrengthPotential, volume;
	
	public AbstractSolidIngredientMemorization(
		MemorizedClass object,
		ObservationMemory observationMemory,
		IDeferredConstructorChainer deferredConstructorChainer
	) {
		super( object, observationMemory, deferredConstructorChainer );
		fraction = object.getFraction();
		boiledness = object.getBoiledness();
		charredness = object.getCharredness();
		brothStrengthPotential = object.getBrothStrengthPotential();
		volume = object.getVolume();
	}

	@Override
	public float getFraction() {
		return fraction;
	}

	@Override
	public float getBoiledness() {
		return boiledness;
	}

	@Override
	public float getCharredness() {
		return charredness;
	}
	
	@Override
	public float getBrothStrengthPotential() {
		return brothStrengthPotential;
	}

	@Override
	public float getVolume() {
		return volume;
	}
}
