package cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IDeferredConstructor;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IDeferredConstructorChainer;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.memorization.essence.AbstractEssenceMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.item.IItemMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.item.container.IContainerMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItemReplication;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.ObservationMemory;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.IStovePlate;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.StovePlateReplication;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.cookware.ICookware;

public class StovePlateMemorization 
	extends AbstractEssenceMemorization<StovePlateReplication>
	implements IStovePlate, IContainerMemorization<StovePlateReplication> {

	protected float temperature;
	protected StoveMemorization stove;
	protected List<IItemMemorization<IItemReplication>> inventory;
	
	public StovePlateMemorization( 
		final StovePlateReplication object,
		final ObservationMemory observationMemory,
		IDeferredConstructorChainer deferredConstructorChainer
	) {
		super( object, observationMemory );
		
		deferredConstructorChainer.addDeferredConstructor(
			new IDeferredConstructor() {
				@Override
				public void construct() {
					temperature = object.getTemperature();
					if ( object.getStove() != null ) {
						stove = (StoveMemorization) observationMemory.getMemorization( object.getStove() );
					} else {
						stove = null;
					}
					inventory = new LinkedList<IItemMemorization<IItemReplication>>();
					for ( IItemReplication item : object.readInventory() ) {
						inventory.add( (IItemMemorization<IItemReplication>) observationMemory.getMemorization( item ) );
					}
				}
			}
		);
	}

	@Override
	public float getTemperature() {
		return temperature;
	}

	@Override
	public boolean canStore(IItem item) {
		return item instanceof ICookware && readInventory().isEmpty();
	}

	@Override
	public boolean canRelease(IItem item) {
		return true;
	}
	
	@Override
	public StoveMemorization getStove() {
		return stove;
	}

	@Override
	public Collection<? extends IItemMemorization<IItemReplication>> readInventory() {
		return inventory;
	}
}
