/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication;

import cz.cuni.amis.pogamut.emohawk.communication.messages.replication.IReplicationEvent;
import cz.cuni.amis.pogamut.emohawk.communication.messages.replication.ObjectReplication;
import cz.cuni.amis.pogamut.emohawk.communication.messages.replication.ObjectTearOff;
import cz.cuni.amis.pogamut.emohawk.communication.messages.replication.ObjectUpdate;
import cz.cuni.amis.pogamut.emohawk.communication.messages.replication.ReplicationCommit;
import cz.cuni.amis.pogamut.emohawk.communication.stream.DecoderStream;
import cz.cuni.amis.pogamut.emohawk.communication.stream.IEncodedObjectInputStream;
import cz.cuni.amis.pogamut.emohawk.communication.stream.PayloadType;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.batchClock.ISimulationClock;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.IObjectReplicationClient;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.event.IReplicaEvent;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.event.ReplicaCreatedEvent;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.event.ReplicaTornOffEvent;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.event.ReplicaUpdatedEvent;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.iface.object.IObjectReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.action.ActionRegistryReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.attribute.AttributeManagerReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.attribute.IAttributeReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.attribute.foggyRef.FoggyRefAttributeReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.attribute.foggyRefList.FoggyRefListAttributeReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.attribute.primitive.PrimitiveAttributeReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.attribute.primitiveList.ListAttributeReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.ds.FoggyReferenceReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.ds.ListMapEntryReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.ds.ListMapReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.ds.PrimitiveBoxReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.ds.sll.SinglyLinkedListNodeReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.ds.sll.SinglyLinkedListReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.game.GameReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.object.IGenericObjectReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.object.SpecializedClass;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.pawn.PawnReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.player.PlayerReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.worldObject.SituationReplica;
import cz.cuni.amis.utils.listener.IListener;
import cz.cuni.amis.utils.listener.Listeners;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ObjectReplicationClient
implements IObjectReplicationClient {
    protected static String LETTER = "[a-zA-Z]";
    protected static String WORD = "(?:" + LETTER + "+)";
    protected static String RAW_PARAMETER = "(?:(?:" + LETTER + "|(?:__))+)";
    protected static Pattern GENERIC_CLASS_NAME_PATTERN = Pattern.compile(WORD + "(?:_" + RAW_PARAMETER + ")*");
    protected static Pattern GENERIC_CLASS_TYPE_PARAMETER_PATTERN = Pattern.compile(RAW_PARAMETER);
    protected HashMap<String, Class<?>> classMap;
    protected HashMap<Integer, IObjectReplica> objectMap = new HashMap();
    protected ISimulationClock simulationClock;
    protected LinkedList<IReplicaEvent> outgoingEventBatch;
    protected Listeners<IListener<IReplicaEvent>> objectEventListeners;

    public ObjectReplicationClient() {
        this.classMap = new HashMap();
        this.objectEventListeners = new Listeners();
        this.outgoingEventBatch = new LinkedList();
        this.classMap.put("int", Integer.class);
        this.classMap.put("bool", Boolean.class);
        this.classMap.put("float", Float.class);
        this.classMap.put("string", String.class);
        this.classMap.put("EhActionRegistry", ActionRegistryReplica.class);
        this.classMap.put("EhIAttribute", IAttributeReplica.class);
        this.classMap.put("EhFoggyRefAttribute", FoggyRefAttributeReplica.class);
        this.classMap.put("EhFoggyRefListAttribute", FoggyRefListAttributeReplica.class);
        this.classMap.put("EhPrimitiveAttribute", PrimitiveAttributeReplica.class);
        this.classMap.put("EhListAttribute", ListAttributeReplica.class);
        this.classMap.put("EhAttributeManager", AttributeManagerReplica.class);
        this.classMap.put("EhSinglyLinkedListNode", SinglyLinkedListNodeReplica.class);
        this.classMap.put("EhSinglyLinkedList", SinglyLinkedListReplica.class);
        this.classMap.put("EhFoggyRef", FoggyReferenceReplica.class);
        this.classMap.put("EhListMapEntry", ListMapEntryReplica.class);
        this.classMap.put("EhListMap", ListMapReplica.class);
        this.classMap.put("EhPrimitiveBox", PrimitiveBoxReplica.class);
        this.classMap.put("EhGame", GameReplica.class);
        this.classMap.put("EhIReplicableObject", IObjectReplica.class);
        this.classMap.put("EhPawn", PawnReplica.class);
        this.classMap.put("EhController", PlayerReplica.class);
        this.classMap.put("EhActorSituationMirror", SituationReplica.class);
    }

    @Override
    public void initSimulationClock(ISimulationClock simulationClock) {
        this.simulationClock = simulationClock;
    }

    @Override
    public IObjectReplica getObject(int replicationId) {
        assert (replicationId >= 0);
        assert (this.objectMap.containsKey(replicationId));
        return this.objectMap.get(replicationId);
    }

    @Override
    public boolean exists(int replicationId) {
        assert (replicationId >= 0);
        return this.objectMap.containsKey(replicationId);
    }

    @Override
    public void registerReplicaEventListener(IListener<IReplicaEvent> listener) {
        this.objectEventListeners.addStrongListener(listener);
    }

    @Override
    public void forgetReplicaEventListener(IListener<IReplicaEvent> listener) {
        this.objectEventListeners.removeListener(listener);
    }

    protected SpecializedClass<?> findClass(String objectClass) {
        String className;
        if (!GENERIC_CLASS_NAME_PATTERN.matcher(objectClass).matches()) {
            throw new RuntimeException("Invalid class name \"" + objectClass + "\".");
        }
        LinkedList<String> typeParameters = new LinkedList<String>();
        if (objectClass.contains("_")) {
            className = objectClass.substring(0, objectClass.indexOf("_"));
            String parameterString = objectClass.substring(className.length() + 1);
            Matcher parameterMatcher = GENERIC_CLASS_TYPE_PARAMETER_PATTERN.matcher(parameterString);
            while (parameterMatcher.find()) {
                String parameter = parameterMatcher.group(0);
                typeParameters.add(parameter.replace("__", "_"));
            }
        } else {
            className = objectClass;
        }
        if (!this.classMap.containsKey(className)) {
            throw new RuntimeException("Can't replicate unknown class \"" + objectClass + "\".");
        }
        Class<?> genericClass = this.classMap.get(className);
        if (genericClass.getTypeParameters().length != typeParameters.size()) {
            throw new RuntimeException("Incorrect number of type parameters for \"" + className + "\" ( " + typeParameters + " ).");
        }
        LinkedList resolvedTypeParameters = new LinkedList();
        for (String typeParameter : typeParameters) {
            resolvedTypeParameters.add(this.findClass(typeParameter));
        }
        SpecializedClass retval = new SpecializedClass(genericClass, resolvedTypeParameters);
        return retval;
    }

    @Override
    public void applyReplicationEvent(IReplicationEvent event) {
        if (event instanceof ObjectReplication) {
            ObjectReplication objectReplicationEvent = (ObjectReplication)event;
            this.replicateObject(objectReplicationEvent.getReplicationIndex(), objectReplicationEvent.getObjectClass());
        } else if (event instanceof ObjectUpdate) {
            ObjectUpdate objectUpdateEvent = (ObjectUpdate)event;
            this.updateObject(objectUpdateEvent.getReplicationIndex(), objectUpdateEvent.getPayloadStream());
        } else if (event instanceof ObjectTearOff) {
            this.tearOffObject(((ObjectTearOff)event).getReplicationIndex());
        } else if (event instanceof ReplicationCommit) {
            this.commit();
        } else {
            throw new AssertionError((Object)"Unexpected replication event.");
        }
    }

    public ISimulationClock getSimulationClock() {
        return this.simulationClock;
    }

    protected void replicateObject(int replicationIndex, String objectClass) {
        IObjectReplica object;
        assert (replicationIndex >= 0);
        assert (!this.exists(replicationIndex));
        SpecializedClass<?> specializedClass = this.findClass(objectClass);
        assert (IObjectReplica.class.isAssignableFrom(specializedClass.getGenericClass()));
        try {
            object = (IObjectReplica)specializedClass.getGenericClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (specializedClass.getGenericClass().getTypeParameters().length > 0) {
            IGenericObjectReplica genericObject = (IGenericObjectReplica)object;
            for (int i = 0; i < specializedClass.getGenericClass().getTypeParameters().length; ++i) {
                genericObject.setTypeParameter(i, specializedClass.getTypeParameter(i));
            }
        }
        object.initializeReplica(this, replicationIndex);
        this.objectMap.put(replicationIndex, object);
        this.outgoingEventBatch.add(new ReplicaCreatedEvent(object));
    }

    protected void updateObject(int replicationIndex, IEncodedObjectInputStream encodedStream) {
        IObjectReplica object = this.getObject(replicationIndex);
        DecoderStream stream = new DecoderStream(encodedStream){

            @Override
            protected IObjectReplica decode(int objectReference) {
                return ObjectReplicationClient.this.getObject(objectReference);
            }
        };
        object.receive(stream);
        assert (stream.tellNext() == PayloadType.PAYLOAD_TYPE_EOF);
        this.outgoingEventBatch.add(new ReplicaUpdatedEvent(object));
    }

    protected void tearOffObject(int replicationIndex) {
        assert (this.exists(replicationIndex));
        IObjectReplica object = this.objectMap.get(replicationIndex);
        this.objectMap.remove(replicationIndex);
        object.finalizeReplication();
        this.outgoingEventBatch.add(new ReplicaTornOffEvent(object));
    }

    protected void commit() {
        HashMap<IObjectReplica, ReplicaCreatedEvent> suspects = new HashMap<IObjectReplica, ReplicaCreatedEvent>();
        ArrayList<Object> intermediateEvents = new ArrayList<Object>();
        for (IReplicaEvent event : this.outgoingEventBatch) {
            if (event instanceof ReplicaCreatedEvent) {
                suspects.put(event.getReplica(), (ReplicaCreatedEvent)event);
                continue;
            }
            if (event instanceof ReplicaUpdatedEvent) {
                if (!suspects.containsKey(event.getReplica())) continue;
                suspects.remove(event.getReplica());
                continue;
            }
            if (!(event instanceof ReplicaTornOffEvent) || !suspects.containsKey(event.getReplica())) continue;
            intermediateEvents.add(suspects.get(event.getReplica()));
            intermediateEvents.add(event);
            suspects.remove(event.getReplica());
        }
        this.outgoingEventBatch.removeAll(intermediateEvents);
        for (IReplicaEvent event : this.outgoingEventBatch) {
            this.objectEventListeners.notify((Listeners.ListenerNotifier)new IListener.Notifier((Object)event));
        }
        this.outgoingEventBatch.clear();
    }
}

