/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory;

import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base3d.worldview.object.IViewable;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.batchClock.ISimulationClock;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.batchClock.SimulationTime;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry.IObjectListing;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry.IViewableObjectRegistry;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry.IWorldObjectRegistry;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.ISightingMemory;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.iface.worldObject.IViewableObjectBelief;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.impl.action.ActionRegistryBelief;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.impl.game.GameBelief;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.impl.pawn.PawnBelief;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.impl.player.PlayerBelief;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.impl.worldObject.AbstractViewableObjectBelief;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.ISnapshotMemorizer;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.iface.object.IObjectMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.iface.worldObject.IViewableObjectMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.impl.action.ActionRegistryMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.impl.game.GameMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.impl.pawn.PawnMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.impl.player.PlayerMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.iface.worldObject.IViewableObjectReplica;
import cz.cuni.amis.utils.ExceptionToString;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public class SightingMemory
implements ISightingMemory {
    protected ISnapshotMemorizer memorizer;
    protected IViewableObjectRegistry inputWorldObjectRegistry;
    protected IWorldObjectRegistry outputWorldObjectRegistry;
    protected ISimulationClock simulationClock;
    protected Map<Class<? extends IObjectMemorization>, Class<? extends AbstractViewableObjectBelief>> classMap;
    protected double shortTermMemoryDuration;
    protected Map<WorldObjectId, AbstractViewableObjectBelief> sightings;
    protected WeakHashMap<AbstractViewableObjectBelief, Boolean> beliefs;
    protected final BeliefSupport beliefSupport = new BeliefSupport();

    public SightingMemory() {
        this.sightings = new HashMap<WorldObjectId, AbstractViewableObjectBelief>();
        this.beliefs = new WeakHashMap();
        this.classMap = new HashMap<Class<? extends IObjectMemorization>, Class<? extends AbstractViewableObjectBelief>>();
        this.classMap.put(ActionRegistryMemorization.class, ActionRegistryBelief.class);
        this.classMap.put(GameMemorization.class, GameBelief.class);
        this.classMap.put(PawnMemorization.class, PawnBelief.class);
        this.classMap.put(PlayerMemorization.class, PlayerBelief.class);
    }

    @Override
    public void refresh() {
        AbstractViewableObjectBelief belief;
        IObjectListing<WorldObjectId, IViewable> visibleObjects = this.inputWorldObjectRegistry.getVisibleObjectListing();
        HashSet<WorldObjectId> newObjects = new HashSet<WorldObjectId>(visibleObjects.getMap().keySet());
        newObjects.removeAll(this.sightings.keySet());
        for (WorldObjectId id : newObjects) {
            AbstractViewableObjectBelief belief2 = this.getBeliefOfVisible(id);
            this.sightings.put(id, belief2);
            this.outputWorldObjectRegistry.registerObject((IWorldObject)belief2.getImmutableFacade(), this.simulationClock.getTime());
        }
        for (Map.Entry<AbstractViewableObjectBelief, Boolean> entry : this.beliefs.entrySet()) {
            belief = entry.getKey();
            Boolean trackedVisible = entry.getValue();
            if (belief == null) continue;
            WorldObjectId id = belief.getImmutableFacade().getId();
            IViewableObjectReplica replica = visibleObjects.getById(IViewableObjectReplica.class, id);
            if (replica == null) {
                if (!trackedVisible.booleanValue()) continue;
                entry.setValue(false);
                this.outputWorldObjectRegistry.notifyObjectUpdated((IWorldObject)belief.getImmutableFacade(), this.simulationClock.getTime());
                continue;
            }
            entry.setValue(true);
            IObjectMemorization memorization = this.memorizer.getMemorization(replica);
            belief.updateMemorization(memorization);
            this.outputWorldObjectRegistry.notifyObjectUpdated((IWorldObject)belief.getImmutableFacade(), this.simulationClock.getTime());
        }
        Iterator<Map.Entry<WorldObjectId, AbstractViewableObjectBelief>> iterator = this.sightings.entrySet().iterator();
        while (iterator.hasNext()) {
            long ageMilliseconds;
            Map.Entry<WorldObjectId, AbstractViewableObjectBelief> entry = iterator.next();
            belief = entry.getValue();
            if (belief.getImmutableFacade().isPlausible() || !((double)(ageMilliseconds = this.simulationClock.getTime().getMilliSeconds() - belief.getImmutableFacade().getSimTime()) >= this.shortTermMemoryDuration / 1000.0)) continue;
            iterator.remove();
            this.outputWorldObjectRegistry.forgetObject((IWorldObject)belief.getImmutableFacade(), this.simulationClock.getTime());
        }
    }

    @Override
    public double getShortTermMemoryDuration() {
        return this.shortTermMemoryDuration;
    }

    @Override
    public void setShortTermMemoryDuration(double value) {
        this.shortTermMemoryDuration = value;
    }

    @Override
    public void initInputViewableWorldObjectRegistry(IViewableObjectRegistry inputViewableWorldObjectRegistry) {
        this.inputWorldObjectRegistry = inputViewableWorldObjectRegistry;
    }

    @Override
    public void initOutputWorldObjectRegistry(IWorldObjectRegistry outputWorldObjectRegistry) {
        this.outputWorldObjectRegistry = outputWorldObjectRegistry;
    }

    @Override
    public void initSimulationClock(ISimulationClock simulationClock) {
        this.simulationClock = simulationClock;
    }

    @Override
    public void initMemorizer(ISnapshotMemorizer memorizer) {
        this.memorizer = memorizer;
    }

    @Override
    public void contradict(IViewableObjectBelief belief) {
        if (belief.isVisible()) {
            throw new IllegalArgumentException("Contradicted belief must not be visible.");
        }
        if (!belief.isPlausible()) {
            return;
        }
        this.sightings.get(belief.getId()).contradict();
        this.outputWorldObjectRegistry.notifyObjectUpdated((IWorldObject)belief, this.simulationClock.getTime());
    }

    protected AbstractViewableObjectBelief makeUnregisteredBelief(IObjectMemorization memorization) {
        assert (memorization != null);
        Class<?> memorizationClass = memorization.getClass();
        Class<? extends AbstractViewableObjectBelief> beliefClass = this.classMap.get(memorizationClass);
        try {
            return beliefClass.getConstructor(memorizationClass, BeliefSupport.class).newInstance(memorization, this.beliefSupport);
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)("Failed to create belief." + ExceptionToString.process((Throwable)e)));
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)("Failed to create belief." + ExceptionToString.process((Throwable)e)));
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)("Failed to create belief." + ExceptionToString.process((Throwable)e)));
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)("Failed to create belief." + ExceptionToString.process((Throwable)e)));
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)("Failed to create belief." + ExceptionToString.process((Throwable)e)));
        }
        catch (SecurityException e) {
            throw new AssertionError((Object)("Failed to create belief." + ExceptionToString.process((Throwable)e)));
        }
    }

    protected AbstractViewableObjectBelief getFreshestBelief(IViewableObjectMemorization fallBackMemorization) {
        if (fallBackMemorization == null) {
            return null;
        }
        for (AbstractViewableObjectBelief belief : this.beliefs.keySet()) {
            if (belief == null || belief.getImmutableFacade().getId() != fallBackMemorization.getId()) continue;
            return belief;
        }
        return this.makeBelief(fallBackMemorization);
    }

    protected AbstractViewableObjectBelief getBeliefOfVisible(WorldObjectId id) {
        IObjectListing<WorldObjectId, IViewable> visibleObjectListing = this.inputWorldObjectRegistry.getVisibleObjectListing();
        IViewable replica = visibleObjectListing.getById(id);
        IViewableObjectMemorization memorization = (IViewableObjectMemorization)this.memorizer.getMemorization(replica);
        return this.getFreshestBelief(memorization);
    }

    protected AbstractViewableObjectBelief makeBelief(IObjectMemorization memorization) {
        AbstractViewableObjectBelief retval = this.makeUnregisteredBelief(memorization);
        this.beliefs.put(retval, retval.getImmutableFacade().isVisible());
        return retval;
    }

    public class BeliefSupport {
        public IViewableObjectBelief getFreshestBelief(IViewableObjectMemorization fallBackMemorization) {
            if (fallBackMemorization == null) {
                return null;
            }
            return SightingMemory.this.getFreshestBelief(fallBackMemorization).getImmutableFacade();
        }

        public SimulationTime getSnapshotTime() {
            return SightingMemory.this.memorizer.getSnapshotTime();
        }
    }
}

