/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry;

import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.batchClock.SimulationTime;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry.IObjectListing;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry.IViewableObjectBeliefRegistry;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry.ObjectListing;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry.ViewableObjectRegistry;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.iface.worldObject.IViewableObjectBelief;

public class ViewableObjectBeliefRegistry
extends ViewableObjectRegistry
implements IViewableObjectBeliefRegistry {
    protected ObjectListing<WorldObjectId, IViewableObjectBelief> plausibleBeliefListing = new ObjectListing();

    @Override
    public IObjectListing<WorldObjectId, IViewableObjectBelief> getPlausibleBeliefs() {
        return this.plausibleBeliefListing;
    }

    @Override
    public void clear() {
        super.clear();
        this.plausibleBeliefListing.clear();
    }

    @Override
    public void registerObject(IWorldObject object, SimulationTime time) {
        super.registerObject(object, time);
        if (object instanceof IViewableObjectBelief) {
            this.updateBeliefTracking((IViewableObjectBelief)object);
        }
    }

    @Override
    public void notifyObjectUpdated(IWorldObject object, SimulationTime time) {
        if (object instanceof IViewableObjectBelief) {
            this.updateBeliefTracking((IViewableObjectBelief)object);
        }
        super.notifyObjectUpdated(object, time);
    }

    @Override
    public void forgetObject(IWorldObject object, SimulationTime time) {
        if (object instanceof IViewableObjectBelief) {
            this.updateBeliefTracking((IViewableObjectBelief)object);
        }
        super.forgetObject(object, time);
    }

    protected void updateBeliefTracking(IViewableObjectBelief object) {
        boolean isTrackedPlausible = this.plausibleBeliefListing.getMap().containsKey(object.getId());
        boolean isPlausible = object.isPlausible();
        if (isPlausible && !isTrackedPlausible) {
            this.plausibleBeliefListing.add(object.getId(), object);
            assert (this.worldObjectListing.getById(object.getId()) != null);
        } else if (!isPlausible && isTrackedPlausible) {
            this.plausibleBeliefListing.remove(object.getId());
        }
    }
}

