/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry;

import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry.IObjectListing;
import cz.cuni.amis.utils.ClassUtils;
import cz.cuni.amis.utils.maps.HashMapMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ObjectListing<TId, TObject>
implements IObjectListing<TId, TObject> {
    protected Map<TId, TObject> objects = new HashMap<TId, TObject>();
    protected Map<TId, TObject> immutableObjectView = Collections.unmodifiableMap(this.objects);
    protected Map<Class<? extends TObject>, Map<TId, TObject>> classSortedObjects = new HashMapMap();
    protected Map<Class<? extends TObject>, Map<TId, TObject>> immutableClassSortedObjectView = Collections.unmodifiableMap(this.classSortedObjects);

    @Override
    public Map<Class<? extends TObject>, Map<TId, TObject>> getClassGroupedMap() {
        return this.immutableClassSortedObjectView;
    }

    @Override
    public <TFilterClass extends TObject> Map<TId, TFilterClass> filterByClass(Class<TFilterClass> filterClass) {
        Map<TId, TObject> map = this.classSortedObjects.get(filterClass);
        return Collections.unmodifiableMap(map);
    }

    @Override
    public Map<TId, TObject> getMap() {
        return this.immutableObjectView;
    }

    @Override
    public TObject getById(TId id) {
        return this.objects.get(id);
    }

    @Override
    public <TTypedObject extends TObject> TTypedObject getById(Class<TTypedObject> type, TId id) {
        TObject object = this.getById(id);
        if (object != null && !type.isInstance(object)) {
            throw new ClassCastException("Found object with ID: " + id + " but it's type (" + object.getClass() + ") doesn't match required type (" + type + ").");
        }
        TObject retval = object;
        return (TTypedObject)retval;
    }

    public void add(TId id, TObject object) {
        this.objects.put(id, object);
        for (Class superClass : ClassUtils.getSubclasses(object.getClass())) {
            this.classSortedObjects.get(superClass).put(id, object);
        }
    }

    public void remove(TId id) {
        assert (this.objects.containsKey(id));
        for (Class superClass : ClassUtils.getSubclasses(this.objects.get(id).getClass())) {
            this.classSortedObjects.get(superClass).remove(id);
        }
        this.objects.remove(id);
    }

    public void clear() {
        this.objects.clear();
        this.classSortedObjects.clear();
    }
}

