/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.communication.worldView;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import cz.cuni.amis.pogamut.base.communication.mediator.IMediator;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base3d.worldview.object.IViewable;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.IHistoricWorldView;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.batchClock.ISimulationClock;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.eventBus.IListenerRegistry;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry.IObjectListing;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry.IViewableObjectBeliefRegistry;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.IHistoricWorldObjectUpdater;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.iface.worldObject.IViewableObjectBelief;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.UT2004SyncLockableWorldView;
import cz.cuni.amis.utils.listener.IListener;
import java.util.Collection;
import java.util.Map;

public class EmohawkWorldView
extends UT2004SyncLockableWorldView
implements IHistoricWorldView {
    public static final String WORLDVIEW_DEPENDENCY = "EmohawkWorldViewDependency";
    protected IHistoricWorldObjectUpdater historicWorldObjectUpdater;
    protected IViewableObjectBeliefRegistry viewableObjectBeliefRegistry;
    protected ISimulationClock simulationClock;

    @Inject
    public EmohawkWorldView(@Named(value="EmohawkWorldViewDependency") ComponentDependencies dependencies, IMediator mediator, IComponentBus bus, IAgentLogger log, IHistoricWorldObjectUpdater historicWorldObjectUpdater, IViewableObjectBeliefRegistry viewableObjectBeliefRegistry, ISimulationClock simulationClock) {
        super(dependencies, mediator, bus, log);
        this.historicWorldObjectUpdater = historicWorldObjectUpdater;
        this.viewableObjectBeliefRegistry = viewableObjectBeliefRegistry;
        this.simulationClock = simulationClock;
        historicWorldObjectUpdater.initWorldObjectRegistry(viewableObjectBeliefRegistry);
        historicWorldObjectUpdater.initSimulationClock(simulationClock);
        viewableObjectBeliefRegistry.registerObjectEventListener(new IListener<IWorldObjectEvent<?>>(){

            public void notify(IWorldObjectEvent<?> event) {
                EmohawkWorldView.this.raiseEvent(event);
            }
        });
    }

    public Map<WorldObjectId, IWorldObject> get() {
        return this.getSeenObjects().getMap();
    }

    public IWorldObject get(WorldObjectId id) {
        return this.getSeenObjects().getById(id);
    }

    public <T extends IWorldObject> T getSingle(Class<T> singletonClass) {
        Collection<T> objects = this.getSeenObjects().filterByClass(singletonClass).values();
        assert (objects.size() == 1);
        return (T)((IWorldObject)objects.iterator().next());
    }

    public <T extends IWorldObject> T get(WorldObjectId id, Class<T> filterClass) {
        return (T)((IWorldObject)this.getSeenObjects().filterByClass(filterClass).get(id));
    }

    public Map<Class, Map<WorldObjectId, IWorldObject>> getAll() {
        Map<Class, Map<WorldObjectId, IWorldObject>> retval;
        Map<Class, Map<WorldObjectId, IWorldObject>> shitTypedRetval = retval = this.getSeenObjects().getClassGroupedMap();
        return shitTypedRetval;
    }

    public <T extends IWorldObject> Map<WorldObjectId, T> getAll(Class<T> filterClass) {
        return this.getSeenObjects().filterByClass(filterClass);
    }

    public IViewable getVisible(WorldObjectId id) {
        return this.getVisibleObjects().getById(id);
    }

    public Map<WorldObjectId, IViewable> getVisible() {
        return this.getVisibleObjects().getMap();
    }

    public Map<Class, Map<WorldObjectId, IViewable>> getAllVisible() {
        Map<Class, Map<WorldObjectId, IViewable>> retval;
        Map<Class, Map<WorldObjectId, IViewable>> shitTypedRetval = retval = this.getVisibleObjects().getClassGroupedMap();
        return shitTypedRetval;
    }

    public <T extends IViewable> Map<WorldObjectId, T> getAllVisible(Class<T> filterClass) {
        return this.getVisibleObjects().filterByClass(filterClass);
    }

    @Override
    public IObjectListing<WorldObjectId, IWorldObject> getSeenObjects() {
        return this.viewableObjectBeliefRegistry.getWorldObjectListing();
    }

    @Override
    public IObjectListing<WorldObjectId, IViewable> getVisibleObjects() {
        return this.viewableObjectBeliefRegistry.getVisibleObjectListing();
    }

    @Override
    public IObjectListing<WorldObjectId, IViewableObjectBelief> getPlausibleBeliefs() {
        return this.viewableObjectBeliefRegistry.getPlausibleBeliefs();
    }

    @Override
    public double getShortTermMemoryDuration() {
        return this.historicWorldObjectUpdater.getShortTermMemoryDuration();
    }

    @Override
    public void setShortTermMemoryDuration(double durationSeconds) {
        this.historicWorldObjectUpdater.setShortTermMemoryDuration(durationSeconds);
    }

    @Override
    public void contradict(IViewableObjectBelief belief) {
        this.historicWorldObjectUpdater.contradict(belief);
    }

    protected void innerNotify(IWorldChangeEvent event) {
        this.simulationClock.applyWorldChange(event);
        this.historicWorldObjectUpdater.applyWorldObjectUpdate(event);
        super.innerNotify(event);
    }

    protected void cleanUp() {
        super.cleanUp();
        this.viewableObjectBeliefRegistry.clear();
    }

    protected void objectCreated(IWorldObject worldObject) {
        this.viewableObjectBeliefRegistry.registerObject(worldObject, this.simulationClock.getTime());
    }

    protected void objectDestroyed(IWorldObject worldObject) {
        this.viewableObjectBeliefRegistry.forgetObject(worldObject, this.simulationClock.getTime());
    }

    protected void objectAppeared(IViewable worldObject) {
        this.viewableObjectBeliefRegistry.notifyObjectUpdated((IWorldObject)worldObject, this.simulationClock.getTime());
        this.currentObjectBatch.add(worldObject);
    }

    protected void objectDisappeared(IViewable worldObject) {
        this.viewableObjectBeliefRegistry.notifyObjectUpdated((IWorldObject)worldObject, this.simulationClock.getTime());
    }

    @Override
    public IListenerRegistry accessEvents() {
        return new IListenerRegistry(){

            @Override
            public void addEventListener(Class<?> eventClass, IWorldEventListener<?> listener) {
                EmohawkWorldView.this.addEventListener(eventClass, listener);
            }

            @Override
            public void addObjectListener(Class<?> objectClass, IWorldObjectEventListener<?, ?> listener) {
                EmohawkWorldView.this.addObjectListener(objectClass, listener);
            }

            @Override
            public void addObjectListener(Class<?> objectClass, Class<?> eventClass, IWorldObjectEventListener<?, ?> listener) {
                EmohawkWorldView.this.addObjectListener(objectClass, eventClass, listener);
            }

            @Override
            public void addObjectListener(WorldObjectId objectId, IWorldObjectEventListener<?, ?> listener) {
                EmohawkWorldView.this.addObjectListener(objectId, listener);
            }

            @Override
            public void addObjectListener(WorldObjectId objectId, Class<?> eventClass, IWorldObjectEventListener<?, ?> listener) {
                EmohawkWorldView.this.addObjectListener(objectId, eventClass, listener);
            }

            @Override
            public void removeEventListener(Class<?> eventClass, IWorldEventListener<?> listener) {
                EmohawkWorldView.this.removeEventListener(eventClass, listener);
            }

            @Override
            public void removeObjectListener(Class<?> objectClass, IWorldObjectEventListener<?, ?> listener) {
                EmohawkWorldView.this.removeObjectListener(objectClass, listener);
            }

            @Override
            public void removeObjectListener(Class<?> objectClass, Class<?> eventClass, IWorldObjectEventListener<?, ?> listener) {
                EmohawkWorldView.this.removeObjectListener(objectClass, eventClass, listener);
            }

            @Override
            public void removeObjectListener(WorldObjectId objectId, IWorldObjectEventListener<?, ?> listener) {
                EmohawkWorldView.this.removeObjectListener(objectId, listener);
            }

            @Override
            public void removeObjectListener(WorldObjectId objectId, Class<?> eventClass, IWorldObjectEventListener<?, ?> listener) {
                EmohawkWorldView.this.removeObjectListener(objectId, eventClass, listener);
            }

            @Override
            public void removeListener(IWorldEventListener<?> listener) {
                EmohawkWorldView.this.removeListener(listener);
            }

            @Override
            public boolean isListening(Class<?> eventClass, IWorldEventListener<?> listener) {
                return EmohawkWorldView.this.isListening(eventClass, listener);
            }

            @Override
            public boolean isListening(Class<?> objectClass, IWorldObjectEventListener<?, ?> listener) {
                return EmohawkWorldView.this.isListening(objectClass, listener);
            }

            @Override
            public boolean isListening(Class<?> objectClass, Class<?> eventClass, IWorldObjectEventListener<?, ?> listener) {
                return EmohawkWorldView.this.isListening(objectClass, eventClass, listener);
            }

            @Override
            public boolean isListening(WorldObjectId objectId, IWorldObjectEventListener<?, ?> listener) {
                return EmohawkWorldView.this.isListening(objectId, listener);
            }

            @Override
            public boolean isListening(WorldObjectId objectId, Class<?> eventClass, IWorldObjectEventListener<?, ?> listener) {
                return EmohawkWorldView.this.isListening(objectId, eventClass, listener);
            }

            @Override
            public boolean isListening(IWorldEventListener<?> listener) {
                return EmohawkWorldView.this.isListening(listener);
            }
        };
    }
}

