/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.communication.stream;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.pogamut.emohawk.communication.stream.IInputStream;
import cz.cuni.amis.pogamut.emohawk.communication.stream.IObjectInputStream;
import cz.cuni.amis.pogamut.emohawk.communication.stream.IOutputStream;
import cz.cuni.amis.pogamut.emohawk.communication.stream.PayloadType;
import cz.cuni.amis.pogamut.emohawk.communication.stream.PrimitiveTools;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Tuple3d;

public class SerializationTools {
    public static void serializeLocation(IOutputStream stream, Location location) {
        stream.writeFloat((float)location.getX());
        stream.writeFloat((float)location.getY());
        stream.writeFloat((float)location.getZ());
    }

    public static Location deserializeLocation(IInputStream stream) {
        if (stream.tellNext() != PayloadType.PAYLOAD_TYPE_FLOAT) {
            return null;
        }
        float x = stream.readFloat();
        if (stream.tellNext() != PayloadType.PAYLOAD_TYPE_FLOAT) {
            return null;
        }
        float y = stream.readFloat();
        if (stream.tellNext() != PayloadType.PAYLOAD_TYPE_FLOAT) {
            return null;
        }
        float z = stream.readFloat();
        return new Location((double)x, (double)y, (double)z);
    }

    public static void serializeVelocity(IOutputStream stream, Velocity velocity) {
        SerializationTools.serializeLocation(stream, velocity.asLocation());
    }

    public static Velocity deserializeVelocity(IInputStream stream) {
        Location location = SerializationTools.deserializeLocation(stream);
        if (location == null) {
            return null;
        }
        return new Velocity((Tuple3d)location.asVector3d());
    }

    public static void serializeRotation(IOutputStream stream, Rotation serializedRotation) {
        stream.writeInt((int)Math.round(serializedRotation.getPitch()));
        stream.writeInt((int)Math.round(serializedRotation.getRoll()));
        stream.writeInt((int)Math.round(serializedRotation.getYaw()));
    }

    public static Rotation deserializeRotation(IInputStream stream) {
        if (stream.tellNext() != PayloadType.PAYLOAD_TYPE_INT) {
            return null;
        }
        double pitch = stream.readInt();
        if (stream.tellNext() != PayloadType.PAYLOAD_TYPE_INT) {
            return null;
        }
        double roll = stream.readInt();
        if (stream.tellNext() != PayloadType.PAYLOAD_TYPE_INT) {
            return null;
        }
        double yaw = stream.readInt();
        return new Rotation(pitch, yaw, roll);
    }

    public static <Element> void serializeList(IOutputStream stream, List<Element> list) {
        stream.writeInt(list.size());
        for (Element element : list) {
            PrimitiveTools.writePrimitive(element, stream);
        }
    }

    public static <Element> List<Element> deserializeList(Class<Element> elementClass, IObjectInputStream stream) {
        ArrayList<Element> retval = new ArrayList<Element>();
        if (stream.tellNext() != PayloadType.PAYLOAD_TYPE_INT) {
            return null;
        }
        int size = stream.readInt();
        for (int i = 0; i < size; ++i) {
            if (!PrimitiveTools.hasPrimitive(elementClass, stream)) {
                return null;
            }
            retval.add(PrimitiveTools.readPrimitive(elementClass, stream));
        }
        return retval;
    }
}

