/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.agent.losChecker;

import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.emohawk.agent.EhAgentInfo;
import cz.cuni.amis.pogamut.emohawk.agent.losChecker.ILosChecker;
import cz.cuni.amis.pogamut.emohawk.agent.losChecker.LosReportEvent;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.IPureHistoricWorldView;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Trace;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.TraceResponse;
import cz.cuni.amis.pogamut.ut2004.utils.UnrealUtils;
import cz.cuni.amis.utils.listener.IListener;
import cz.cuni.amis.utils.listener.Listeners;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class RayTracingLosChecker
implements ILosChecker {
    public static String DEFAULT_TRACE_COMMAND_PREFIX = "LosChecker";
    protected IAct act;
    protected IPureHistoricWorldView worldView;
    protected EhAgentInfo agentInfo;
    protected String traceCommandPrefix;
    protected int nextTraceIndex;
    protected Listeners<IListener<LosReportEvent>> losReportListenrs;
    protected final IWorldEventListener<TraceResponse> traceResponseListener = new IWorldEventListener<TraceResponse>(){

        public void notify(TraceResponse event) {
            RayTracingLosChecker.this.processTraceResponse(event);
        }
    };

    public RayTracingLosChecker(IAct act, IPureHistoricWorldView worldView, EhAgentInfo agentInfo) {
        this.act = act;
        this.worldView = worldView;
        this.agentInfo = agentInfo;
        this.losReportListenrs = new Listeners();
        this.traceCommandPrefix = DEFAULT_TRACE_COMMAND_PREFIX;
        this.nextTraceIndex = 0;
        worldView.accessEvents().addEventListener(TraceResponse.class, this.traceResponseListener);
    }

    public void dispose() {
        this.worldView.accessEvents().removeEventListener(TraceResponse.class, this.traceResponseListener);
    }

    public void setTraceCommandPrefix(String prefix) {
        this.traceCommandPrefix = prefix;
    }

    @Override
    public void requestLosCheck(Location location) {
        this.act.act((CommandMessage)new Trace(this.traceCommandPrefix + this.nextTraceIndex, null, location, Boolean.valueOf(true)));
        ++this.nextTraceIndex;
    }

    @Override
    public void registerLosReportListener(IListener<LosReportEvent> listener) {
        this.losReportListenrs.addStrongListener(listener);
    }

    @Override
    public void forgetLosReportListener(IListener<LosReportEvent> listener) {
        this.losReportListenrs.removeListener(listener);
    }

    @Override
    public boolean isWithinFov(Location location) {
        Location locationOffset = location.getLocation().sub(this.agentInfo.getPawn().getLocation()).getNormalized();
        double azimuth = UnrealUtils.unrealDegreeToRad((double)this.agentInfo.getPawn().getRotation().getYaw());
        double elevation = UnrealUtils.unrealDegreeToRad((double)this.agentInfo.getPawn().getRotation().getPitch());
        Matrix3d matrix = new Matrix3d();
        matrix.rotY(elevation);
        matrix.rotZ(azimuth);
        Vector3d vector = new Vector3d(1.0, 0.0, 0.0);
        matrix.transform((Tuple3d)vector);
        Location focusOffset = new Location((Tuple3d)vector);
        double angleBetweenFocusAndLocation = Math.acos(locationOffset.dot(focusOffset));
        return angleBetweenFocusAndLocation < 1.0471975511965976;
    }

    public void processTraceResponse(TraceResponse traceResponse) {
        if (!traceResponse.isTraceActors()) {
            return;
        }
        Location location = traceResponse.getTo();
        boolean isInLos = !traceResponse.isResult() && !this.isWithinFov(location);
        this.losReportListenrs.notify((Listeners.ListenerNotifier)new IListener.Notifier((Object)new LosReportEvent(location, isInLos)));
    }
}

