/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer;

import cz.cuni.amis.pogamut.emohawk.communication.worldView.batchClock.SimulationTime;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.IDeferredConstructorChainer;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.ISnapshotMemorizer;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.SemifinishedMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.iface.object.IObjectMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.impl.action.ActionRegistryMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.impl.game.GameMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.impl.pawn.PawnMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.memorization.impl.player.PlayerMemorization;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.iface.object.IObjectReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.action.ActionRegistryReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.game.GameReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.pawn.PawnReplica;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.impl.player.PlayerReplica;
import cz.cuni.amis.utils.ExceptionToString;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class SnapshotMemorizer
implements ISnapshotMemorizer {
    protected Map<IObjectReplica, IObjectMemorization> memorizationCache = new HashMap<IObjectReplica, IObjectMemorization>();
    protected Map<IObjectMemorization, IObjectReplica> reverseMemorizationCache = new HashMap<IObjectMemorization, IObjectReplica>();
    protected SimulationTime currentSnapshotTime = null;
    protected Map<Class<? extends IObjectReplica>, Class<? extends IObjectMemorization>> classMap = new HashMap<Class<? extends IObjectReplica>, Class<? extends IObjectMemorization>>();

    public SnapshotMemorizer() {
        this.classMap.put(ActionRegistryReplica.class, ActionRegistryMemorization.class);
        this.classMap.put(GameReplica.class, GameMemorization.class);
        this.classMap.put(PawnReplica.class, PawnMemorization.class);
        this.classMap.put(PlayerReplica.class, PlayerMemorization.class);
    }

    @Override
    public IObjectMemorization getMemorization(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof IObjectReplica)) {
            throw new AssertionError((Object)"Memorizer implementation can handle only replicas (IObjectReplica).");
        }
        IObjectReplica replica = (IObjectReplica)object;
        assert (replica.isLive());
        IObjectMemorization memorization = this.memorizationCache.get(replica);
        if (memorization == null) {
            SemifinishedMemorization semifinishedMemorization = this.makeMemorization(replica);
            memorization = semifinishedMemorization.memorization;
            this.memorizationCache.put(replica, memorization);
            this.reverseMemorizationCache.put(memorization, replica);
            semifinishedMemorization.finishConstruction();
        }
        IObjectMemorization retval = memorization;
        return retval;
    }

    @Override
    public IObjectReplica getPreimage(IObjectMemorization freshMemorization) {
        return this.reverseMemorizationCache.get(freshMemorization);
    }

    @Override
    public void nextSnapshot(SimulationTime nextSnapshotTime) {
        this.memorizationCache.clear();
        this.reverseMemorizationCache.clear();
        assert (this.currentSnapshotTime == null || this.currentSnapshotTime.getMilliSeconds() < nextSnapshotTime.getMilliSeconds());
        this.currentSnapshotTime = nextSnapshotTime;
    }

    @Override
    public SimulationTime getSnapshotTime() {
        return this.currentSnapshotTime;
    }

    protected SemifinishedMemorization makeMemorization(IObjectReplica object) {
        SemifinishedMemorization retval = new SemifinishedMemorization();
        Class<?> replicaClass = object.getClass();
        Class<? extends IObjectMemorization> memorizationClass = this.classMap.get(replicaClass);
        assert (memorizationClass != null);
        try {
            retval.memorization = memorizationClass.getConstructor(replicaClass, ISnapshotMemorizer.class, IDeferredConstructorChainer.class).newInstance(object, this, retval);
            return retval;
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)("Failed to create memorization." + ExceptionToString.process((Throwable)e)));
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)("Failed to create memorization." + ExceptionToString.process((Throwable)e)));
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)("Failed to create memorization." + ExceptionToString.process((Throwable)e)));
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)("Failed to create memorization." + ExceptionToString.process((Throwable)e)));
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)("Failed to create memorization." + ExceptionToString.process((Throwable)e)));
        }
        catch (SecurityException e) {
            throw new AssertionError((Object)("Failed to create memorization." + ExceptionToString.process((Throwable)e)));
        }
    }
}

