/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.batchClock.ISimulationClock;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.batchClock.SimulationTime;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry.IViewableObjectRegistry;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry.IWorldObjectRegistry;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.IWorldObjectUpdater;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.IHistoricWorldObjectUpdater;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.ISightingMemory;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.iface.worldObject.IViewableObjectBelief;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.snapshotMemorizer.ISnapshotMemorizer;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;

public class HistoricWorldObjectUpdater
implements IHistoricWorldObjectUpdater {
    protected IWorldObjectUpdater replicationWorldObjectUpdater;
    protected IViewableObjectRegistry replicationWorldObjectRegistry;
    protected ISightingMemory sightingMemory;
    protected ISnapshotMemorizer snapshotMemorizer;

    @Inject
    public HistoricWorldObjectUpdater(IWorldObjectUpdater replicationWorldObjectUpdater, IViewableObjectRegistry replicationWorldObjectRegistry, ISightingMemory sightingMemory, ISnapshotMemorizer snapshotMemorizer) {
        this.replicationWorldObjectUpdater = replicationWorldObjectUpdater;
        this.replicationWorldObjectRegistry = replicationWorldObjectRegistry;
        this.sightingMemory = sightingMemory;
        this.snapshotMemorizer = snapshotMemorizer;
        replicationWorldObjectUpdater.initWorldObjectRegistry(replicationWorldObjectRegistry);
        sightingMemory.initInputViewableWorldObjectRegistry(replicationWorldObjectRegistry);
        sightingMemory.initMemorizer(snapshotMemorizer);
    }

    @Override
    public double getShortTermMemoryDuration() {
        return this.sightingMemory.getShortTermMemoryDuration();
    }

    @Override
    public void setShortTermMemoryDuration(double durationSeconds) {
        this.sightingMemory.setShortTermMemoryDuration(durationSeconds);
    }

    @Override
    public void applyWorldObjectUpdate(IWorldChangeEvent event) {
        if (event instanceof BeginMessage) {
            this.snapshotMemorizer.nextSnapshot(SimulationTime.fromMilliSeconds(event.getSimTime()));
        }
        this.replicationWorldObjectUpdater.applyWorldObjectUpdate(event);
        if (event instanceof EndMessage) {
            this.sightingMemory.refresh();
        }
    }

    @Override
    public void initWorldObjectRegistry(IWorldObjectRegistry worldObjectRegistry) {
        this.sightingMemory.initOutputWorldObjectRegistry(worldObjectRegistry);
    }

    @Override
    public void initSimulationClock(ISimulationClock simulationClock) {
        this.sightingMemory.initSimulationClock(simulationClock);
        this.replicationWorldObjectUpdater.initSimulationClock(simulationClock);
    }

    @Override
    public void contradict(IViewableObjectBelief belief) {
        this.sightingMemory.contradict(belief);
    }
}

