/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry;

import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectDestroyedEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectFirstEncounteredEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.batchClock.SimulationTime;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry.IObjectListing;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry.IWorldObjectRegistry;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry.ObjectListing;
import cz.cuni.amis.utils.listener.IListener;
import cz.cuni.amis.utils.listener.Listeners;

public class WorldObjectRegistry
implements IWorldObjectRegistry {
    protected ObjectListing<WorldObjectId, IWorldObject> worldObjectListing = new ObjectListing();
    protected Listeners<IListener<IWorldObjectEvent<?>>> worldObjectEventListeners = new Listeners();

    @Override
    public IObjectListing<WorldObjectId, IWorldObject> getWorldObjectListing() {
        return this.worldObjectListing;
    }

    @Override
    public void registerObjectEventListener(IListener<IWorldObjectEvent<?>> listener) {
        this.worldObjectEventListeners.addStrongListener(listener);
    }

    @Override
    public void forgetObjectEventListener(IListener<IWorldObjectEvent<?>> listener) {
        this.worldObjectEventListeners.removeListener(listener);
    }

    @Override
    public void clear() {
        this.worldObjectListing.clear();
    }

    @Override
    public void applyWorldObjectEvent(IWorldChangeEvent event) {
        SimulationTime time = SimulationTime.fromMilliSeconds(event.getSimTime());
        if (event instanceof WorldObjectFirstEncounteredEvent) {
            this.registerObject(((WorldObjectFirstEncounteredEvent)event).getObject(), time);
        } else if (event instanceof WorldObjectUpdatedEvent) {
            this.notifyObjectUpdated(((WorldObjectUpdatedEvent)event).getObject(), time);
        } else if (event instanceof WorldObjectDestroyedEvent) {
            this.forgetObject(((WorldObjectDestroyedEvent)event).getObject(), time);
        }
    }

    @Override
    public void registerObject(IWorldObject object, SimulationTime time) {
        assert (object.getId() != null);
        this.worldObjectListing.add(object.getId(), object);
        this.worldObjectEventListeners.notify((Listeners.ListenerNotifier)new IListener.Notifier((Object)new WorldObjectFirstEncounteredEvent(object, time.getMilliSeconds())));
        this.worldObjectEventListeners.notify((Listeners.ListenerNotifier)new IListener.Notifier((Object)new WorldObjectUpdatedEvent(object, time.getMilliSeconds())));
    }

    @Override
    public void notifyObjectUpdated(IWorldObject object, SimulationTime time) {
        this.worldObjectEventListeners.notify((Listeners.ListenerNotifier)new IListener.Notifier((Object)new WorldObjectUpdatedEvent(object, time.getMilliSeconds())));
    }

    @Override
    public void forgetObject(IWorldObject object, SimulationTime time) {
        this.worldObjectEventListeners.notify((Listeners.ListenerNotifier)new IListener.Notifier((Object)new WorldObjectDestroyedEvent(object, time.getMilliSeconds())));
        this.worldObjectListing.remove(object.getId());
    }
}

