/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry;

import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base3d.worldview.object.IViewable;
import cz.cuni.amis.pogamut.base3d.worldview.object.event.WorldObjectAppearedEvent;
import cz.cuni.amis.pogamut.base3d.worldview.object.event.WorldObjectDisappearedEvent;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.batchClock.SimulationTime;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry.IObjectListing;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry.IViewableObjectRegistry;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry.ObjectListing;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry.WorldObjectRegistry;
import cz.cuni.amis.utils.listener.IListener;
import cz.cuni.amis.utils.listener.Listeners;

public class ViewableObjectRegistry
extends WorldObjectRegistry
implements IViewableObjectRegistry {
    protected ObjectListing<WorldObjectId, IViewable> visibleObjectListing = new ObjectListing();

    @Override
    public IObjectListing<WorldObjectId, IViewable> getVisibleObjectListing() {
        return this.visibleObjectListing;
    }

    @Override
    public void clear() {
        super.clear();
        this.visibleObjectListing.clear();
    }

    @Override
    public void registerObject(IWorldObject object, SimulationTime time) {
        super.registerObject(object, time);
        if (object instanceof IViewable) {
            this.updateVisibilityTracking((IViewable)object, time);
        }
    }

    @Override
    public void notifyObjectUpdated(IWorldObject object, SimulationTime time) {
        if (object instanceof IViewable) {
            this.updateVisibilityTracking((IViewable)object, time);
        }
        super.notifyObjectUpdated(object, time);
    }

    @Override
    public void forgetObject(IWorldObject object, SimulationTime time) {
        if (object instanceof IViewable) {
            this.updateVisibilityTracking((IViewable)object, false, time);
        }
        super.forgetObject(object, time);
    }

    protected void updateVisibilityTracking(IViewable object, SimulationTime time) {
        this.updateVisibilityTracking(object, object.isVisible(), time);
    }

    protected void updateVisibilityTracking(IViewable object, boolean isActuallyVisible, SimulationTime time) {
        boolean isTrackedVisible = this.visibleObjectListing.getMap().containsKey(object.getId());
        if (isActuallyVisible && !isTrackedVisible) {
            this.visibleObjectListing.add(object.getId(), object);
            assert (this.worldObjectListing.getById(object.getId()) != null);
            this.worldObjectEventListeners.notify((Listeners.ListenerNotifier)new IListener.Notifier((Object)new WorldObjectAppearedEvent(object, time.getMilliSeconds())));
        } else if (!isActuallyVisible && isTrackedVisible) {
            this.visibleObjectListing.remove(object.getId());
            this.worldObjectEventListeners.notify((Listeners.ListenerNotifier)new IListener.Notifier((Object)new WorldObjectDisappearedEvent(object, time.getMilliSeconds())));
        }
    }
}

