/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.agent.beliefContradictor;

import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.IViewable;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.emohawk.agent.EhAgentInfo;
import cz.cuni.amis.pogamut.emohawk.agent.losChecker.ILosChecker;
import cz.cuni.amis.pogamut.emohawk.agent.losChecker.LosReportEvent;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.IPureHistoricWorldView;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.iface.worldObject.IViewableObjectBelief;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.utils.listener.IListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AbsenceBeliefContradictor {
    protected ILosChecker losChecker;
    protected HashMap<WorldObjectId, Importance> importanceMap;
    protected EhAgentInfo agentInfo;
    protected IPureHistoricWorldView worldView;
    protected int losChecksPerFrame;
    protected double losCheckExposingRadius;
    protected final IWorldEventListener<EndMessage> endMessageListener = new IWorldEventListener<EndMessage>(){

        public void notify(EndMessage event) {
            AbsenceBeliefContradictor.this.observe();
        }
    };
    protected final IListener<LosReportEvent> losReportListener = new IListener<LosReportEvent>(){

        public void notify(LosReportEvent event) {
            if (!event.isInLos()) {
                return;
            }
            for (IViewableObjectBelief belief : AbsenceBeliefContradictor.this.worldView.getPlausibleBeliefs().getMap().values()) {
                Location location;
                if (belief.isVisible() || !belief.isPlausible() || !(belief instanceof ILocated) || !((location = ((ILocated)belief).getLocation()).getDistance(event.getLocation()) <= AbsenceBeliefContradictor.this.losCheckExposingRadius)) continue;
                AbsenceBeliefContradictor.this.contradict(belief);
            }
        }
    };

    public AbsenceBeliefContradictor(ILosChecker losChecker, EhAgentInfo agentInfo, IPureHistoricWorldView worldView, int losChecksPerFrame, double losCheckExposingRadius) {
        this.losChecker = losChecker;
        this.agentInfo = agentInfo;
        this.worldView = worldView;
        this.losChecksPerFrame = losChecksPerFrame;
        this.losCheckExposingRadius = losCheckExposingRadius;
        this.importanceMap = new HashMap();
        worldView.accessEvents().addEventListener(EndMessage.class, this.endMessageListener);
        losChecker.registerLosReportListener(this.losReportListener);
    }

    public void dispose() {
        this.worldView.accessEvents().removeEventListener(EndMessage.class, this.endMessageListener);
        this.losChecker.forgetLosReportListener(this.losReportListener);
    }

    public void overrideImportance(WorldObjectId id, double importance, double duration) {
        if (!this.importanceMap.containsKey(id)) {
            this.importanceMap.put(id, new Importance(this.agentInfo.getTime()));
        }
        this.importanceMap.get(id).addOverride(new ImportanceOverride(importance, this.agentInfo.getTime() + duration));
    }

    protected void updateImportances() {
        Iterator<Map.Entry<WorldObjectId, Importance>> entryIterator = this.importanceMap.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<WorldObjectId, Importance> entry = entryIterator.next();
            Importance importance = entry.getValue();
            importance.cleanOldOverrides(this.agentInfo.getTime());
            IViewableObjectBelief belief = this.worldView.getPlausibleBeliefs().getById(entry.getKey());
            if (!importance.isDefaultImportance() || belief != null && belief.isPlausible()) continue;
            entryIterator.remove();
        }
        for (IViewable viewable : this.worldView.getVisibleObjects().getMap().values()) {
            if (!(viewable instanceof IViewableObjectBelief)) continue;
            if (!this.importanceMap.containsKey(viewable.getId())) {
                this.importanceMap.put(viewable.getId(), new Importance(this.agentInfo.getTime()));
                continue;
            }
            this.importanceMap.get(viewable.getId()).setLastLosCheckAttemptTime(this.agentInfo.getTime());
        }
    }

    protected void requestLosChecks() {
        LocatedBelief locatedBelief;
        for (int i = 0; i < this.losChecksPerFrame && (locatedBelief = this.findBeliefWithTopLosCheckPriority()) != null; ++i) {
            this.losChecker.requestLosCheck(locatedBelief.getLocated().getLocation());
            this.importanceMap.get(locatedBelief.getBelief().getId()).setLastLosCheckAttemptTime(this.agentInfo.getTime());
        }
    }

    protected void observe() {
        this.updateImportances();
        this.requestLosChecks();
    }

    protected void contradict(IViewableObjectBelief belief) {
        this.worldView.contradict(belief);
    }

    protected LocatedBelief findBeliefWithTopLosCheckPriority() {
        LocatedBelief beliefWithTopLosCheckPriority = null;
        double topLosCheckPriority = 0.0;
        for (IViewableObjectBelief belief : this.worldView.getPlausibleBeliefs().getMap().values()) {
            double losCheckPriority = 0.0;
            LocatedBelief locatedBelief = null;
            if (belief instanceof ILocated) {
                locatedBelief = new LocatedBelief((ILocated)belief, belief);
                losCheckPriority = this.computeLosCheckPriority(locatedBelief);
            }
            if (!(topLosCheckPriority < losCheckPriority)) continue;
            beliefWithTopLosCheckPriority = locatedBelief;
            topLosCheckPriority = losCheckPriority;
        }
        return beliefWithTopLosCheckPriority;
    }

    protected double computeLosCheckPriority(LocatedBelief belief) {
        if (belief.getLocated().getLocation() == null || belief.getBelief().isVisible() || !belief.getBelief().isPlausible()) {
            return 0.0;
        }
        if (!this.losChecker.isWithinFov(belief.getLocated().getLocation())) {
            return 0.0;
        }
        Importance importance = this.importanceMap.get(belief.getBelief().getId());
        double timeSinceSeen = this.agentInfo.getTime() - belief.getBelief().getMemorization().getSnapshotTime();
        double timeSinceLosCheckAttempt = this.agentInfo.getTime() - importance.getLastLosCheckTime();
        double distance = Math.max(50.0, this.agentInfo.getPawn().getLocation().getDistance(belief.getLocated().getLocation()));
        return Math.max(0.0, importance.getImportance() * timeSinceSeen * timeSinceLosCheckAttempt / distance);
    }

    protected class LocatedBelief {
        protected ILocated located;
        protected IViewableObjectBelief belief;

        public LocatedBelief(ILocated located, IViewableObjectBelief belief) {
            assert (located == belief);
            this.located = located;
            this.belief = belief;
        }

        public ILocated getLocated() {
            return this.located;
        }

        public IViewableObjectBelief getBelief() {
            return this.belief;
        }
    }

    protected class ImportanceOverride {
        public double overrideEndTime;
        public double value;

        public ImportanceOverride(double value, double overrideEndTime) {
            this.overrideEndTime = overrideEndTime;
            this.value = value;
        }
    }

    protected class Importance {
        protected List<ImportanceOverride> overrides = new LinkedList<ImportanceOverride>();
        protected double lastLosCheckAttemptTime;

        public Importance(double currentTime) {
            this.lastLosCheckAttemptTime = currentTime;
        }

        public double getLastLosCheckTime() {
            return this.lastLosCheckAttemptTime;
        }

        public void setLastLosCheckAttemptTime(double value) {
            this.lastLosCheckAttemptTime = value;
        }

        public double getImportance() {
            if (this.overrides.isEmpty()) {
                return 1.0;
            }
            return this.overrides.get((int)0).value;
        }

        public void addOverride(ImportanceOverride override) {
            AbsenceBeliefContradictor.this.updateImportances();
            while (this.overrides.size() > 0 && this.overrides.get((int)0).overrideEndTime <= override.overrideEndTime) {
                this.overrides.remove(0);
            }
            this.overrides.add(0, override);
        }

        public void cleanOldOverrides(double currentTime) {
            while (this.overrides.size() > 0 && this.overrides.get((int)0).overrideEndTime < currentTime) {
                this.overrides.remove(0);
            }
        }

        public boolean isDefaultImportance() {
            return this.overrides.isEmpty();
        }
    }
}

