/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute;

import cz.cuni.amis.pogamut.emohawk.agent.module.attribute.AttributeUpstream;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.AttributeAccess;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.IAssignableAttributeReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.IAttributeReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.ListMapEntryReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.ListMapReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.SpecializedClass;
import java.util.Iterator;

public class AttributeRawView<Attribute extends IAssignableAttributeReplica<IntermediateValue>, IntermediateValue> {
    protected SpecializedClass<Attribute> attributeClass;
    protected AttributeUpstream upstream;
    protected ListMapReplica<IAttributeReplica> attributes;

    public AttributeRawView(ListMapReplica<IAttributeReplica> attributes, AttributeUpstream upstream, SpecializedClass<Attribute> attributeClass) {
        this.attributes = attributes;
        this.upstream = upstream;
        this.attributeClass = attributeClass;
    }

    public ListMapReplica<IAttributeReplica> getAttributes() {
        return this.attributes;
    }

    public Attribute getAttributeRecord(String attributeName) {
        IAssignableAttributeReplica attribute = (IAssignableAttributeReplica)this.attributes.get(attributeName);
        assert (this.attributeClass.isInstance(attribute));
        return (Attribute)attribute;
    }

    public void send(String attributeName, IntermediateValue value) {
        Attribute attribute = this.getAttributeRecord(attributeName);
        assert (attribute.getAccess() == AttributeAccess.ATTRIBUTE_ACCESS_WRITE);
        assert (attribute.getOwnerControllerId() == -1 || attribute.getOwnerControllerId() == this.upstream.getControllerId());
        attribute.serialize(this.upstream.getOutputStream(), value);
        this.upstream.setAttribute(attribute.getReplicationId());
    }

    public boolean exists(String attributeName, AttributeAccess access) {
        if (this.attributes.containsKey(attributeName)) {
            IAttributeReplica attribute = this.attributes.get(attributeName);
            return this.attributeClass.isInstance(attribute) && attribute.getAccess() == access;
        }
        return false;
    }

    public Iterator<ListMapEntryReplica<Attribute>> iterator() {
        final Iterator<ListMapEntryReplica<IAttributeReplica>> iterator = this.attributes.iterator();
        return new Iterator<ListMapEntryReplica<Attribute>>(){
            ListMapEntryReplica<Attribute> next;

            @Override
            public boolean hasNext() {
                this.fetchNext();
                return this.next != null;
            }

            @Override
            public ListMapEntryReplica<Attribute> next() {
                this.fetchNext();
                assert (this.next != null);
                return this.next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can't remove attribute.");
            }

            protected void fetchNext() {
                if (this.next != null) {
                    return;
                }
                while (iterator.hasNext()) {
                    ListMapEntryReplica candidate = (ListMapEntryReplica)iterator.next();
                    if (!AttributeRawView.this.attributeClass.isInstance(candidate.getValue())) continue;
                    this.next = new ListMapEntryReplica<IAssignableAttributeReplica>(candidate.getKey(), (IAssignableAttributeReplica)candidate.getValue());
                    return;
                }
            }
        };
    }
}

