/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.agent.module.replication;

import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.IReplicatedObjectTracker;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ControllerInfoReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.PawnReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.ActionRegistryReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.AttributeManagerReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.IAttributeReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.foggyref.FoggyRefAttributeReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.foggyreflist.FoggyRefListAttributeReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.primitive.PrimitiveAttributeReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.primitivelist.ListAttributeReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.FoggyRefReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.ListMapEntryReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.ListMapReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.PrimitiveBoxReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.sll.SinglyLinkedListCoreReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.sll.SinglyLinkedListNodeReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.sll.SinglyLinkedListReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.IGenericObjectReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.IObjectReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.ReplicationId;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.SpecializedClass;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.StreamManager;
import cz.cuni.amis.pogamut.emohawk.communication.replication.ObjectReplication;
import cz.cuni.amis.pogamut.emohawk.communication.replication.ObjectTearOff;
import cz.cuni.amis.pogamut.emohawk.communication.replication.ObjectUpdate;
import cz.cuni.amis.pogamut.emohawk.communication.stream.PayloadType;
import cz.cuni.amis.pogamut.ut2004.bot.IUT2004Bot;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ObjectReplicationClient
implements IReplicatedObjectTracker {
    protected static String LETTER = "[a-zA-Z]";
    protected static String WORD = "(?:" + LETTER + "+)";
    protected static String RAW_PARAMETER = "(?:(?:" + LETTER + "|(?:__))+)";
    protected static Pattern GENERIC_CLASS_NAME_PATTERN = Pattern.compile(WORD + "(?:_" + RAW_PARAMETER + ")*");
    protected static Pattern GENERIC_CLASS_TYPE_PARAMETER_PATTERN = Pattern.compile(RAW_PARAMETER);
    protected HashMap<String, Class<?>> classMap;
    protected HashMap<Integer, IObjectReplica> objectMap;
    protected StreamManager streamManager;
    protected HashMap<Class<?>, Object> modules;
    protected IWorldEventListener<ObjectReplication> objectReplicationListener = new IWorldEventListener<ObjectReplication>(){

        public void notify(ObjectReplication event) {
            IObjectReplica object;
            ReplicationId replicationId = event.getReplicationId();
            String objectClass = event.getObjectClass();
            assert (!ObjectReplicationClient.this.exists(replicationId.getIndex()));
            SpecializedClass<?> specializedClass = ObjectReplicationClient.this.findClass(objectClass);
            assert (IObjectReplica.class.isAssignableFrom(specializedClass.getGenericClass()));
            try {
                object = (IObjectReplica)specializedClass.getGenericClass().newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            if (specializedClass.getGenericClass().getTypeParameters().length > 0) {
                IGenericObjectReplica genericObject = (IGenericObjectReplica)object;
                for (int i = 0; i < specializedClass.getGenericClass().getTypeParameters().length; ++i) {
                    genericObject.setTypeParameter(i, specializedClass.getTypeParameter(i));
                }
            }
            object.initializeImage(ObjectReplicationClient.this, replicationId);
            ObjectReplicationClient.this.objectMap.put(replicationId.getIndex(), object);
        }
    };
    protected IWorldEventListener<ObjectTearOff> objectTearOffListener = new IWorldEventListener<ObjectTearOff>(){

        public void notify(ObjectTearOff event) {
            int replicationIndex = event.getReplicationIndex();
            assert (ObjectReplicationClient.this.exists(replicationIndex));
            IObjectReplica object = ObjectReplicationClient.this.objectMap.get(replicationIndex);
            ObjectReplicationClient.this.objectMap.remove(replicationIndex);
            object.finalizeReplication();
        }
    };
    protected IWorldEventListener<ObjectUpdate> objectUpdateListener = new IWorldEventListener<ObjectUpdate>(){

        public void notify(ObjectUpdate event) {
            int replicationIndex = event.getReplicationIndex();
            IObjectReplica object = ObjectReplicationClient.this.getObject(replicationIndex);
            object.receive(ObjectReplicationClient.this.streamManager.getInputStream());
            assert (ObjectReplicationClient.this.streamManager.getInputStream().tellNext() == PayloadType.PAYLOAD_TYPE_EOF);
            ObjectReplicationClient.this.streamManager.clearInput();
        }
    };

    public ObjectReplicationClient(IUT2004Bot bot, StreamManager streamManager) {
        this.objectMap = new HashMap();
        this.classMap = new HashMap();
        this.streamManager = streamManager;
        this.modules = new HashMap();
        bot.getWorldView().addEventListener(ObjectReplication.class, this.objectReplicationListener);
        bot.getWorldView().addEventListener(ObjectUpdate.class, this.objectUpdateListener);
        bot.getWorldView().addEventListener(ObjectTearOff.class, this.objectTearOffListener);
        this.classMap.put("int", Integer.class);
        this.classMap.put("bool", Boolean.class);
        this.classMap.put("float", Float.class);
        this.classMap.put("string", String.class);
        this.classMap.put("EhIReplicableObject", IObjectReplica.class);
        this.classMap.put("EhPawn", PawnReplica.class);
        this.classMap.put("EhIAttribute", IAttributeReplica.class);
        this.classMap.put("EhSinglyLinkedList", SinglyLinkedListReplica.class);
        this.classMap.put("EhSinglyLinkedListCore", SinglyLinkedListCoreReplica.class);
        this.classMap.put("EhSinglyLinkedListNode", SinglyLinkedListNodeReplica.class);
        this.classMap.put("EhAttributeManager", AttributeManagerReplica.class);
        this.classMap.put("EhListMap", ListMapReplica.class);
        this.classMap.put("EhListMapEntry", ListMapEntryReplica.class);
        this.classMap.put("EhPrimitiveBox", PrimitiveBoxReplica.class);
        this.classMap.put("EhFoggyRef", FoggyRefReplica.class);
        this.classMap.put("EhPrimitiveAttribute", PrimitiveAttributeReplica.class);
        this.classMap.put("EhListAttribute", ListAttributeReplica.class);
        this.classMap.put("EhFoggyRefAttribute", FoggyRefAttributeReplica.class);
        this.classMap.put("EhFoggyRefListAttribute", FoggyRefListAttributeReplica.class);
        this.classMap.put("EhControllerInfo", ControllerInfoReplica.class);
        this.classMap.put("EhActionRegistry", ActionRegistryReplica.class);
    }

    @Override
    public IObjectReplica getObject(int replicationId) {
        assert (replicationId >= 0);
        assert (this.objectMap.containsKey(replicationId));
        return this.objectMap.get(replicationId);
    }

    @Override
    public boolean exists(int replicationId) {
        assert (replicationId >= 0);
        return this.objectMap.containsKey(replicationId);
    }

    public <TModuleType, TModuleImpl extends TModuleType> void registerModule(Class<TModuleType> moduleType, TModuleImpl moduleImpl) {
        assert (!this.modules.containsKey(moduleType));
        this.modules.put(moduleType, moduleImpl);
    }

    public <TModule> TModule getModule(Class<TModule> moduleType) {
        assert (this.modules.containsKey(moduleType));
        Object retval = this.modules.get(moduleType);
        return (TModule)retval;
    }

    protected SpecializedClass<?> findClass(String objectClass) {
        String className;
        if (!GENERIC_CLASS_NAME_PATTERN.matcher(objectClass).matches()) {
            throw new RuntimeException("Invalid class name \"" + objectClass + "\".");
        }
        LinkedList<String> typeParameters = new LinkedList<String>();
        if (objectClass.contains("_")) {
            className = objectClass.substring(0, objectClass.indexOf("_"));
            String parameterString = objectClass.substring(className.length() + 1);
            Matcher parameterMatcher = GENERIC_CLASS_TYPE_PARAMETER_PATTERN.matcher(parameterString);
            while (parameterMatcher.find()) {
                String parameter = parameterMatcher.group(0);
                typeParameters.add(parameter.replace("__", "_"));
            }
        } else {
            className = objectClass;
        }
        if (!this.classMap.containsKey(className)) {
            throw new RuntimeException("Can't replicate unknown class \"" + objectClass + "\".");
        }
        Class<?> genericClass = this.classMap.get(className);
        if (genericClass.getTypeParameters().length != typeParameters.size()) {
            throw new RuntimeException("Incorrect number of type parameters for \"" + className + "\" ( " + typeParameters + " ).");
        }
        LinkedList resolvedTypeParameters = new LinkedList();
        for (String typeParameter : typeParameters) {
            resolvedTypeParameters.add(this.findClass(typeParameter));
        }
        SpecializedClass retval = new SpecializedClass(genericClass, resolvedTypeParameters);
        return retval;
    }
}

