package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;


/** Object describing specialized java class
 * 
 * Stores type parameters along with java Class.
 * 
 * @author Paletz
 * 
 * @param <BaseClass>
 */
public class SpecializedClass<BaseClass> {
	
	protected Class<BaseClass> genericClass;
	protected ArrayList<SpecializedClass<?>> typeParameters;
	
	public SpecializedClass( Class<BaseClass> genericClass, List<SpecializedClass<?>> typeParameters ) {
		this.genericClass = genericClass;
		this.typeParameters = new ArrayList<SpecializedClass<?>>( typeParameters );
	}
	
	/** Create specialized class from non-parametric java class
	 * 
	 * @param <PlainClass> java class
	 * @param plainClass java class
	 * @return specialized class describing non-parametric java class
	 */
	public static <PlainClass> SpecializedClass<PlainClass> fromPlain( Class<PlainClass> plainClass ) {
		return new SpecializedClass<PlainClass>( plainClass, new LinkedList<SpecializedClass<?>>() );
	}
	
	public SpecializedClass<?> getTypeParameter( int index ) {
		return typeParameters.get(index);
	}
	
	public Class<BaseClass> getGenericClass() {
		return genericClass;
	}
	
	@Override
	public boolean equals(Object other) {
		if ( other instanceof SpecializedClass<?> ) {
			SpecializedClass<?> otherClass = (SpecializedClass<?>) other;
			if ( getGenericClass() != otherClass.getGenericClass() ) {
				return false;
			}
			for ( int i=0; i<getGenericClass().getTypeParameters().length; ++i ) {
				if ( !getTypeParameter(i).equals( otherClass.getTypeParameter(i) ) ) {
					return false;
				}
			}
			return true;
		} else {
			return false;
		}
	}
	
	/** Tell if an object is instance of this specialized class
	 * 
	 * Variance in type parameters is not allowed.
	 * 
	 * @param object object
	 * @return true if the object is instance of this specialized class
	 */
	public boolean isInstance( Object object ) {
		if ( !genericClass.isInstance( object) ) {
			return false;
		}
		
		if ( object instanceof IGenericObjectReplica ) {
			IGenericObjectReplica genericObject = (IGenericObjectReplica) object;
			assert( typeParameters.size() <= genericObject.getTypeParameterCount() ); // derived object may have more type parameters
			for ( int i=0; i<typeParameters.size(); ++i ) {
				if ( ! typeParameters.get(i).equals( genericObject.getTypeParameter( i ) ) ) {
					return false;
				}
			}
			
			return true;
		} else {
			return true;
		}
	}
}
